/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib;

import com.inwebo.iwlib.IW;
import com.inwebo.iwlib.Ixml;
import com.inwebo.iwlib.Util;
import com.inwebo.iwlib.security.Oaep;
import com.inwebo.iwlib.security.SecureRandom;
import com.inwebo.iwlib.security.Sha256;

public class ActionSetup {
    IW iw;
    String action;
    private String challenge;
    private long needsync;

    public ActionSetup(IW iw) {
        this.iw = iw;
    }

    public boolean needsync() {
        return this.needsync != 0L;
    }

    private String filterpin(String pin) {
        ActionSetup actionSetup = this;
        if (actionSetup.iw.IsMa()) {
            return "" + Sha256.sha256int(pin);
        }
        return pin;
    }

    public long start(String action, String args) {
        this.action = action;
        String params = "&mode=" + IW.wsfilter(action) + "&id=" + IW.wsfilter(this.iw.data.iwid) + "&macid=" + IW.wsfilter(this.iw.macid) + "&lastsync=" + IW.wsfilter(this.iw.data.iwTsync) + "&version=" + IW.wsfilter(this.iw.iwhostversion) + args;
        Ixml root = this.iw.wscall(this.iw.WEBSERVICE(), "ActionSetup", params);
        if (root == null) {
            return 1L;
        }
        String err = root.subtagValue("err");
        this.iw.data.checknewversion(root);
        if (err.compareTo("OK") != 0) {
            return this.iw.errorfromserver(root, err);
        }
        this.challenge = root.subtagValue("challenge");
        this.needsync = root.subtagValueInt("needsync");
        String Kfact = root.subtagValue("Kfact");
        if (Kfact.length() > 0) {
            this.iw.data.iwKpubFactory = Kfact;
            this.iw.data.dataTouch();
        }
        this.iw.Kiw = root.subtagValue("Kiw");
        if (this.iw.Kiw.length() > 0) {
            this.iw.Kiw = Oaep.KpubDecode(this.iw.Kiw, this.iw.data.iwKpubFactory);
        }
        this.iw.pinmode = root.subtagValueInt("pinmode");
        String id = root.subtagValue("serviceid");
        this.iw.serviceindex = this.iw.data.getServiceIndex(id);
        this.iw.pushAction = root.subtagValue("action");
        this.iw.pushAlias = root.subtagValue("alias");
        return 0L;
    }

    private String computeReq(String pin, String serial) {
        boolean upgrade = this.action.equals("upgrade");
        String K0 = upgrade ? this.iw.data.iwK1 : this.iw.data.iwK0;
        String K1 = this.iw.data.iwK1;
        pin = upgrade ? this.filterpin(pin) : pin;
        String src0 = "" + this.challenge + ";" + K0 + ";" + serial;
        IW.log("R0 from " + src0);
        String R0 = Sha256.sha256(src0);
        IW.log("R1 from " + this.challenge + ";" + K0 + ";" + K1);
        String R1 = Sha256.sha256("" + this.challenge + ";" + K0 + ";" + K1);
        IW.log("R2 from " + this.challenge + ";" + K0 + ";" + pin);
        String R2 = Sha256.sha256("" + this.challenge + ";" + K0 + ";" + pin);
        return "&R0=" + IW.wsfilter(R0) + "&R1=" + IW.wsfilter(R1) + "&R2=" + IW.wsfilter(R2);
    }

    public long finalize(String pin, String args) {
        return this.finalize(pin, args, null, null, null);
    }

    public long finalize(String pin, String args, String serial, String newpin, String nKma) {
        long ms_n;
        String Kma = this.iw.generateKma(pin);
        if (serial == null) {
            serial = this.iw.getSerial();
        }
        if (newpin == null) {
            newpin = pin;
        }
        if (nKma == null) {
            nKma = Kma;
        }
        String Rseq = this.computeReq(pin, serial);
        String ack = "&ack=";
        int i = 0;
        while ((long)i < this.iw.data.iwmsgn) {
            if (this.iw.data.iwmsgack[i] == 2L) {
                ack = ack + this.iw.data.iwmsgid[i] + ":";
            }
            ++i;
        }
        String params = "&mode=" + IW.wsfilter(this.action) + "&id=" + IW.wsfilter(this.iw.data.iwid) + "&macid=" + IW.wsfilter(this.iw.macid) + "&lastsync=" + IW.wsfilter(this.iw.data.iwTsync) + "&version=" + IW.wsfilter(this.iw.iwhostversion) + "&lang=" + IW.wsfilter(this.iw.lang) + Rseq + ack + args;
        Ixml root = this.iw.wscall(this.iw.WEBSERVICE(), "ActionFinalize", params);
        if (root == null) {
            return 1L;
        }
        String err = root.subtagValue("err");
        this.iw.data.checknewversion(root);
        if (err.compareTo("OK") != 0) {
            return this.iw.errorfromserver(root, err);
        }
        this.iw.data.synchro(this.iw, root, nKma);
        if (this.action.equals("password")) {
            this.iw.data.password(Kma, nKma);
        }
        if (!this.action.equals("messages")) {
            this.iw.data.iwblocked = 0L;
        }
        if (this.action.equals("upgrade")) {
            this.iw.data.mustupgrade = false;
        }
        if (this.action.equals("activate") && newpin.isEmpty() && this.iw.pinmode == 0L) {
            this.iw.data.iwhasnopin = 1L;
        }
        if ((this.action.equals("addService") || this.action.equals("synchro")) && this.iw.pinmode == 2L) {
            this.iw.data.iwhasnopin = 0L;
            this.iw.data.password(Kma, nKma);
        }
        this.iw.code = root.subtagValue("code");
        this.iw.defi = root.subtagValueInt("defi");
        this.iw.format = root.subtagValue("format");
        String sid = root.subtagValue("serviceid");
        this.iw.serviceindex = this.iw.data.getServiceIndex(sid);
        this.iw.pushAction = root.subtagValue("action");
        this.iw.pushAlias = root.subtagValue("alias");
        this.iw.pushContext = root.subtagValue("context");
        if (this.iw.pushContext != null) {
            try {
                String utf;
                this.iw.pushContext = utf = new String(this.iw.pushContext.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (Throwable t) {
                IW.debugSet("catch pushContext in utf-8");
            }
        }
        if ((ms_n = root.subtagValueInt("ms_n")) > 0L) {
            this.challenge = root.subtagValue("challenge");
            Ixml[] lid = root.subtags("ms_id");
            Ixml[] lkey = root.subtags("ms_key");
            this.action = "ms";
            Rseq = this.computeReq(newpin, this.iw.getSerial());
            String ms_keys = "";
            ms_keys = "&ms_n=" + ms_n;
            SecureRandom r = new SecureRandom();
            int i2 = 0;
            while ((long)i2 < ms_n) {
                String ms = Util.rand128(r);
                String K = Oaep.KpubDecode(lkey[i2].getVal(), this.iw.data.iwKpubFactory);
                String msK = Oaep.KpubEncode(ms, K);
                String key = Util.encodeAesFromHex(ms, nKma);
                String id = lid[i2].getVal();
                this.iw.data.addSecret(id, key);
                ms_keys = ms_keys + "&ms_id" + i2 + "=" + id + "&ms_val" + i2 + "=" + msK;
                ++i2;
            }
            params = "&mode=" + IW.wsfilter(this.action) + "&id=" + IW.wsfilter(this.iw.data.iwid) + "&macid=" + IW.wsfilter(this.iw.macid) + "&lastsync=" + IW.wsfilter(this.iw.data.iwTsync) + Rseq + ms_keys;
            root = this.iw.wscall(this.iw.WEBSERVICE(), "ActionFinalize", params);
            if (root == null) {
                return 13L;
            }
            err = root.subtagValue("err");
            if (err.compareTo("OK") != 0) {
                return 13L;
            }
            this.iw.data.synchro(this.iw, root, nKma);
        }
        return 0L;
    }
}

