/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib;

import com.inwebo.iwlib.IW;

public class Ixml {
    String tag;
    String val;
    Ixml child;
    Ixml next;
    static int endvxml;

    public static String StringReplace(String src, String patt, String newpatt) {
        int p = 0;
        while ((p = src.indexOf(patt, p)) >= 0) {
            src = src.substring(0, p) + newpatt + src.substring(p + patt.length());
            p += newpatt.length();
        }
        return src;
    }

    static String StringHexchar(String src) {
        int p;
        while ((p = src.indexOf("&#x")) >= 0) {
            int r = src.indexOf(";", p);
            if (r < 0) {
                return src;
            }
            String code = src.substring(p + 3, r);
            try {
                int c = Integer.parseInt(code, 16);
                byte[] b = new byte[]{(byte)c};
                src = src.substring(0, p) + new String(b, "ISO8859_1") + src.substring(r + 1);
            }
            catch (Throwable t) {
                IW.debugSet("catch StringHexchar");
                return src;
            }
        }
        return src;
    }

    static String StringDecchar(String src) {
        int r;
        int p;
        while ((p = src.indexOf("&#")) >= 0 && (r = src.indexOf(";", p)) >= 0) {
            String code = src.substring(p + 2, r);
            try {
                int c = Integer.parseInt(code);
                byte[] b = new byte[]{(byte)c};
                src = src.substring(0, p) + new String(b, "ISO-8859-1") + src.substring(r + 1);
            }
            catch (Throwable t) {
                IW.debugSet("catch StringDecchar");
                break;
            }
        }
        return src;
    }

    static String filterData(String src) {
        src = Ixml.StringReplace(src, "&lt;", "<");
        src = Ixml.StringReplace(src, "&gt;", ">");
        src = Ixml.StringReplace(src, "&amp;", "&");
        src = Ixml.StringReplace(src, "&quot;", "\"");
        src = Ixml.StringReplace(src, "&apos;", "'");
        src = Ixml.StringHexchar(src);
        src = Ixml.StringDecchar(src);
        return src;
    }

    Ixml(String t) {
        this.tag = t;
        this.val = "";
        this.child = null;
        this.next = null;
    }

    public String getVal() {
        if (this.val == null) {
            return "";
        }
        return this.val;
    }

    public long getValInt() {
        try {
            if (this.val == null || this.val.length() == 0) {
                return 0L;
            }
            long x = Integer.parseInt(this.val);
            return x;
        }
        catch (Throwable t) {
            IW.debugSet("catch getValInt");
            return 0L;
        }
    }

    public Ixml getChild() {
        return this.child;
    }

    public String subtagValue(String name) {
        Ixml x = this.child;
        while (x != null) {
            if (name.compareTo(x.tag) == 0) {
                return x.getVal();
            }
            x = x.next;
        }
        return "";
    }

    public long subtagValueInt(String name) {
        Ixml x = this.child;
        while (x != null) {
            if (name.compareTo(x.tag) == 0) {
                return x.getValInt();
            }
            x = x.next;
        }
        return 0L;
    }

    public Ixml[] subtags(String name) {
        int n = 0;
        Ixml x = this.child;
        while (x != null) {
            if (name.compareTo(x.tag) == 0) {
                ++n;
            }
            x = x.next;
        }
        Ixml[] tb = new Ixml[n];
        int i = 0;
        Ixml x2 = this.child;
        while (x2 != null) {
            if (name.compareTo(x2.tag) == 0) {
                tb[i++] = x2;
            }
            x2 = x2.next;
        }
        return tb;
    }

    public void dump() {
        try {
            System.out.print("<" + this.tag + ">");
            if (this.child != null) {
                System.out.print("\n");
                this.child.dump();
            } else {
                System.out.print(this.val);
            }
            System.out.print("</" + this.tag + ">\n");
            if (this.next != null) {
                this.next.dump();
            }
        }
        catch (Throwable th) {
            IW.debugSet("catch dump");
        }
    }

    static void line(String src, int i) {
        int i0 = 0;
        int i1 = 0;
        int n = 0;
        while (i1 >= 0 && i1 <= i) {
            ++n;
            i0 = i1;
            if ((i1 = src.indexOf("\n", i0)) < 0) continue;
            ++i1;
        }
        if (i1 == -1) {
            i1 = src.length();
        }
        try {
            IW.debugSet("line " + n + " : " + src.substring(i0, i1));
        }
        catch (Throwable th) {
            IW.debugSet("catch line");
        }
    }

    static String trimfirstword(String src) {
        if (src == null) {
            return null;
        }
        int i = (src = src.trim()).indexOf(" ");
        if (i >= 0) {
            src = src.substring(0, i).trim();
        }
        if ((i = src.indexOf("\n")) >= 0) {
            src = src.substring(0, i).trim();
        }
        return src;
    }

    static Ixml tagCreate(String src, int i0, int i1) {
        try {
            String tag = Ixml.trimfirstword(src.substring(i0, i1));
            if (tag.length() == 0) {
                Ixml.line(src, i0);
                IW.debugSet("vxml error : tag is empty");
                return null;
            }
            return new Ixml(tag);
        }
        catch (Throwable t) {
            IW.debugSet("catch tagCreate");
            return null;
        }
    }

    public static Ixml parseTag(String src, int i0) {
        try {
            endvxml = -1;
            int i = src.indexOf(">", i0);
            if (i < 0) {
                Ixml.line(src, i0);
                IW.debugSet("vxml error : '>' is missing");
                return null;
            }
            if (src.charAt(i - 1) == '/') {
                Ixml x = Ixml.tagCreate(src, i0 + 1, i - 1);
                if (x == null) {
                    return x;
                }
                endvxml = i + 1;
                return x;
            }
            Ixml x = Ixml.tagCreate(src, i0 + 1, i);
            if (x == null) {
                return x;
            }
            i0 = i + 1;
            Ixml lasty = null;
            while (true) {
                if ((i = src.indexOf("<", i0)) < 0) {
                    Ixml.line(src, i0);
                    IW.debugSet("vxml error : closing tag </" + x.tag + "> is missing");
                    return null;
                }
                if (src.charAt(i + 1) == '/') {
                    int j = src.indexOf(">", i + 2);
                    if (j < 0) {
                        Ixml.line(src, i + 2);
                        IW.debugSet("vxml error : '>' is missing");
                        return null;
                    }
                    String tagend = Ixml.trimfirstword(src.substring(i + 2, j));
                    if (tagend.compareTo(x.tag) != 0) {
                        Ixml.line(src, i);
                        IW.debugSet("vxml error : found </" + tagend + "> instead of </" + x.tag + ">");
                        return null;
                    }
                    if (x.child == null) {
                        x.val = Ixml.filterData(src.substring(i0, i));
                    }
                    endvxml = j + 1;
                    return x;
                }
                Ixml y = Ixml.parseTag(src, i);
                if (y == null) {
                    return null;
                }
                if (endvxml < 0) {
                    return null;
                }
                if (lasty != null) {
                    lasty.next = y;
                } else {
                    x.child = y;
                }
                lasty = y;
                i0 = endvxml;
            }
        }
        catch (Throwable t) {
            IW.debugSet("catch parseTag");
            return null;
        }
    }

    public static Ixml parse(String src) {
        try {
            int i = src.indexOf("<", 0);
            if (i >= 0 && src.charAt(i + 1) == '?') {
                i = src.indexOf("<", i + 1);
            }
            if (i < 0) {
                Ixml.line(src, 0);
                IW.debugSet("vxml error : '<' is missing");
                return null;
            }
            if (src.charAt(i + 1) == '/') {
                Ixml.line(src, i);
                IW.debugSet("vxml error : '<' is missing, found '</'");
                return null;
            }
            return Ixml.parseTag(src, i);
        }
        catch (Throwable t) {
            IW.debugSet("catch parse");
            return null;
        }
    }
}

