/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.apache.http.impl.cookie;

import com.inwebo.repackaged.org.apache.http.annotation.Immutable;
import com.inwebo.repackaged.org.apache.http.conn.util.PublicSuffixList;
import com.inwebo.repackaged.org.apache.http.conn.util.PublicSuffixMatcher;
import com.inwebo.repackaged.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.inwebo.repackaged.org.apache.http.cookie.Cookie;
import com.inwebo.repackaged.org.apache.http.cookie.CookieOrigin;
import com.inwebo.repackaged.org.apache.http.cookie.MalformedCookieException;
import com.inwebo.repackaged.org.apache.http.cookie.SetCookie;
import com.inwebo.repackaged.org.apache.http.util.Args;

@Immutable
public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(handler, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixList suffixList) {
        Args.notNull(handler, "Cookie handler");
        Args.notNull(suffixList, "Public suffix list");
        this.handler = handler;
        this.publicSuffixMatcher = new PublicSuffixMatcher(suffixList.getRules(), suffixList.getExceptions());
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        String domain = cookie.getDomain();
        if (!domain.equalsIgnoreCase("localhost") && this.publicSuffixMatcher.matches(domain)) {
            return false;
        }
        return this.handler.match(cookie, origin);
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        this.handler.parse(cookie, value);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        this.handler.validate(cookie, origin);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(handler, "Cookie attribute handler");
        return publicSuffixMatcher != null ? new PublicSuffixDomainFilter(handler, publicSuffixMatcher) : handler;
    }
}

