/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.glassfish.jersey.client.authentication;

import com.inwebo.repackaged.javax.ws.rs.client.ClientRequestContext;
import com.inwebo.repackaged.javax.ws.rs.client.ClientResponseContext;
import com.inwebo.repackaged.org.glassfish.jersey.client.authentication.HttpAuthenticationFilter;
import com.inwebo.repackaged.org.glassfish.jersey.client.authentication.RequestAuthenticationException;
import com.inwebo.repackaged.org.glassfish.jersey.client.authentication.ResponseAuthenticationException;
import com.inwebo.repackaged.org.glassfish.jersey.client.internal.LocalizationMessages;
import com.inwebo.repackaged.org.glassfish.jersey.internal.util.Base64;

final class BasicAuthenticator {
    private final HttpAuthenticationFilter.Credentials defaultCredentials;

    BasicAuthenticator(HttpAuthenticationFilter.Credentials defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    private String calculateAuthentication(HttpAuthenticationFilter.Credentials credentials) {
        String username = credentials.getUsername();
        byte[] password = credentials.getPassword();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = new byte[]{};
        }
        byte[] prefix = (username + ":").getBytes(HttpAuthenticationFilter.CHARACTER_SET);
        byte[] usernamePassword = new byte[prefix.length + password.length];
        System.arraycopy(prefix, 0, usernamePassword, 0, prefix.length);
        System.arraycopy(password, 0, usernamePassword, prefix.length, password.length);
        return "Basic " + Base64.encodeAsString(usernamePassword);
    }

    public void filterRequest(ClientRequestContext request) throws RequestAuthenticationException {
        HttpAuthenticationFilter.Credentials credentials = HttpAuthenticationFilter.getCredentials(request, this.defaultCredentials, HttpAuthenticationFilter.Type.BASIC);
        if (credentials == null) {
            throw new RequestAuthenticationException(LocalizationMessages.AUTHENTICATION_CREDENTIALS_MISSING_BASIC());
        }
        request.getHeaders().add("Authorization", this.calculateAuthentication(credentials));
    }

    public boolean filterResponseAndAuthenticate(ClientRequestContext request, ClientResponseContext response) {
        String authenticate = response.getHeaders().getFirst("WWW-Authenticate");
        if (authenticate != null && authenticate.trim().toUpperCase().startsWith("BASIC")) {
            HttpAuthenticationFilter.Credentials credentials = HttpAuthenticationFilter.getCredentials(request, this.defaultCredentials, HttpAuthenticationFilter.Type.BASIC);
            if (credentials == null) {
                throw new ResponseAuthenticationException(null, LocalizationMessages.AUTHENTICATION_CREDENTIALS_MISSING_BASIC());
            }
            return HttpAuthenticationFilter.repeatRequest(request, response, this.calculateAuthentication(credentials));
        }
        return false;
    }
}

