/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.javassist.bytecode.annotation;

import com.inwebo.repackaged.javassist.ClassPool;
import com.inwebo.repackaged.javassist.bytecode.ConstPool;
import com.inwebo.repackaged.javassist.bytecode.annotation.AnnotationsWriter;
import com.inwebo.repackaged.javassist.bytecode.annotation.MemberValue;
import com.inwebo.repackaged.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class ByteMemberValue
extends MemberValue {
    int valueIndex;

    public ByteMemberValue(int index, ConstPool cp) {
        super('B', cp);
        this.valueIndex = index;
    }

    public ByteMemberValue(byte b, ConstPool cp) {
        super('B', cp);
        this.setValue(b);
    }

    public ByteMemberValue(ConstPool cp) {
        super('B', cp);
        this.setValue((byte)0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Byte(this.getValue());
    }

    @Override
    Class getType(ClassLoader cl) {
        return Byte.TYPE;
    }

    public byte getValue() {
        return (byte)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(byte newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Byte.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitByteMemberValue(this);
    }
}

