/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.jvnet.tiger_types;

import com.inwebo.repackaged.org.jvnet.tiger_types.Types;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lister<T> {
    public final Class itemType;
    public final Type itemGenericType;
    protected final Collection r;
    private static final Class[] CONCRETE_TYPES = new Class[]{ArrayList.class, HashSet.class};

    protected Lister(Class itemType, Type itemGenericType) {
        this(itemType, itemGenericType, new ArrayList());
    }

    protected Lister(Class itemType, Type itemGenericType, Collection r) {
        this.itemType = itemType;
        this.itemGenericType = itemGenericType;
        this.r = r;
    }

    public void add(Object o) {
        this.r.add(o);
    }

    public abstract T toCollection();

    public static Lister create(Type t) {
        return Lister.create(Types.erasure(t), t);
    }

    public static <T> Lister<T> create(Class<T> c, Type t) {
        if (c.isArray()) {
            Class<?> ct = c.getComponentType();
            return new Lister(ct, ct){

                public Object toCollection() {
                    return this.r.toArray((Object[])Array.newInstance(this.itemType, this.r.size()));
                }
            };
        }
        if (Collection.class.isAssignableFrom(c)) {
            Type col = Types.getBaseClass(t, Collection.class);
            Object itemType = col instanceof ParameterizedType ? Types.getTypeArgument(col, 0) : Object.class;
            Collection<Enum> items = null;
            try {
                items = (EnumSet<Enum>)c.newInstance();
            }
            catch (InstantiationException e) {
                for (Class ct : CONCRETE_TYPES) {
                    if (!c.isAssignableFrom(ct)) continue;
                    try {
                        items = (Collection)ct.newInstance();
                        break;
                    }
                    catch (InstantiationException x) {
                        throw Lister.toError(x);
                    }
                    catch (IllegalAccessException x) {
                        throw Lister.toError(x);
                    }
                }
                if (items == null && c == EnumSet.class) {
                    items = EnumSet.noneOf(Types.erasure((Type)itemType).asSubclass(Enum.class));
                }
                if (items == null) {
                    throw new IllegalArgumentException("Don't know how to instanciate " + c);
                }
            }
            catch (IllegalAccessException e) {
                throw Lister.toError(e);
            }
            return new Lister(Types.erasure((Type)itemType), (Type)itemType, items){

                public Object toCollection() {
                    return this.r;
                }
            };
        }
        return null;
    }

    private static IllegalAccessError toError(IllegalAccessException e) {
        IllegalAccessError x = new IllegalAccessError();
        x.initCause(e);
        return x;
    }

    private static InstantiationError toError(InstantiationException e) {
        InstantiationError x = new InstantiationError();
        x.initCause(e);
        return x;
    }
}

