/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.glassfish.jersey.apache.connector;

import com.inwebo.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.inwebo.repackaged.javax.ws.rs.ProcessingException;
import com.inwebo.repackaged.javax.ws.rs.client.Client;
import com.inwebo.repackaged.javax.ws.rs.core.Configuration;
import com.inwebo.repackaged.javax.ws.rs.core.MultivaluedMap;
import com.inwebo.repackaged.javax.ws.rs.core.Response;
import com.inwebo.repackaged.org.apache.http.Header;
import com.inwebo.repackaged.org.apache.http.HttpEntity;
import com.inwebo.repackaged.org.apache.http.HttpHost;
import com.inwebo.repackaged.org.apache.http.HttpRequest;
import com.inwebo.repackaged.org.apache.http.auth.AuthScope;
import com.inwebo.repackaged.org.apache.http.auth.UsernamePasswordCredentials;
import com.inwebo.repackaged.org.apache.http.client.CookieStore;
import com.inwebo.repackaged.org.apache.http.client.CredentialsProvider;
import com.inwebo.repackaged.org.apache.http.client.HttpClient;
import com.inwebo.repackaged.org.apache.http.client.config.RequestConfig;
import com.inwebo.repackaged.org.apache.http.client.methods.CloseableHttpResponse;
import com.inwebo.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.inwebo.repackaged.org.apache.http.client.methods.RequestBuilder;
import com.inwebo.repackaged.org.apache.http.client.protocol.HttpClientContext;
import com.inwebo.repackaged.org.apache.http.config.ConnectionConfig;
import com.inwebo.repackaged.org.apache.http.config.Registry;
import com.inwebo.repackaged.org.apache.http.config.RegistryBuilder;
import com.inwebo.repackaged.org.apache.http.conn.HttpClientConnectionManager;
import com.inwebo.repackaged.org.apache.http.conn.ManagedHttpClientConnection;
import com.inwebo.repackaged.org.apache.http.conn.routing.HttpRoute;
import com.inwebo.repackaged.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.inwebo.repackaged.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.inwebo.repackaged.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.inwebo.repackaged.org.apache.http.conn.ssl.SSLContexts;
import com.inwebo.repackaged.org.apache.http.entity.AbstractHttpEntity;
import com.inwebo.repackaged.org.apache.http.entity.BufferedHttpEntity;
import com.inwebo.repackaged.org.apache.http.impl.auth.BasicScheme;
import com.inwebo.repackaged.org.apache.http.impl.client.BasicAuthCache;
import com.inwebo.repackaged.org.apache.http.impl.client.BasicCookieStore;
import com.inwebo.repackaged.org.apache.http.impl.client.BasicCredentialsProvider;
import com.inwebo.repackaged.org.apache.http.impl.client.CloseableHttpClient;
import com.inwebo.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import com.inwebo.repackaged.org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import com.inwebo.repackaged.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.inwebo.repackaged.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.inwebo.repackaged.org.apache.http.impl.io.ChunkedOutputStream;
import com.inwebo.repackaged.org.apache.http.io.SessionOutputBuffer;
import com.inwebo.repackaged.org.apache.http.protocol.HttpContext;
import com.inwebo.repackaged.org.apache.http.util.TextUtils;
import com.inwebo.repackaged.org.apache.http.util.VersionInfo;
import com.inwebo.repackaged.org.glassfish.jersey.apache.connector.LocalizationMessages;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientProperties;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientRequest;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientResponse;
import com.inwebo.repackaged.org.glassfish.jersey.client.RequestEntityProcessing;
import com.inwebo.repackaged.org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import com.inwebo.repackaged.org.glassfish.jersey.client.spi.Connector;
import com.inwebo.repackaged.org.glassfish.jersey.internal.util.PropertiesHelper;
import com.inwebo.repackaged.org.glassfish.jersey.message.internal.HeaderUtils;
import com.inwebo.repackaged.org.glassfish.jersey.message.internal.OutboundMessageContext;
import com.inwebo.repackaged.org.glassfish.jersey.message.internal.ReaderWriter;
import com.inwebo.repackaged.org.glassfish.jersey.message.internal.Statuses;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

class ApacheConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(ApacheConnector.class.getName());
    private static final VersionInfo vi = VersionInfo.loadVersionInfo("com.inwebo.repackaged.org.apache.http.client", HttpClientBuilder.class.getClassLoader());
    private static final String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
    private final CloseableHttpClient client;
    private final CookieStore cookieStore;
    private final boolean preemptiveBasicAuth;
    private final RequestConfig requestConfig;

    ApacheConnector(Client client, Configuration config) {
        Boolean preemptiveBasicAuthProperty;
        Object proxyUri;
        Object reqConfig;
        Object connectionManager = config.getProperties().get("jersey.config.apache.client.connectionManager");
        if (connectionManager != null && !(connectionManager instanceof HttpClientConnectionManager)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.connectionManager", connectionManager.getClass().getName(), HttpClientConnectionManager.class.getName()));
        }
        if ((reqConfig = config.getProperties().get("jersey.config.apache.client.requestConfig")) != null && !(reqConfig instanceof RequestConfig)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.requestConfig", reqConfig.getClass().getName(), RequestConfig.class.getName()));
            reqConfig = null;
        }
        SSLContext sslContext = client.getSslContext();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setConnectionManager(this.getConnectionManager(client, config, sslContext));
        clientBuilder.setConnectionManagerShared(PropertiesHelper.getValue(config.getProperties(), "jersey.config.apache.client.connectionManagerShared", false, null));
        clientBuilder.setSslcontext(sslContext);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        Object credentialsProvider = config.getProperty("jersey.config.apache.client.credentialsProvider");
        if (credentialsProvider != null && credentialsProvider instanceof CredentialsProvider) {
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if ((proxyUri = config.getProperty("jersey.config.client.proxy.uri")) != null) {
            String password;
            URI u = ApacheConnector.getProxyUri(proxyUri);
            HttpHost proxy = new HttpHost(u.getHost(), u.getPort(), u.getScheme());
            String userName = ClientProperties.getValue(config.getProperties(), "jersey.config.client.proxy.username", String.class);
            if (userName != null && (password = ClientProperties.getValue(config.getProperties(), "jersey.config.client.proxy.password", String.class)) != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(u.getHost(), u.getPort()), new UsernamePasswordCredentials(userName, password));
                clientBuilder.setDefaultCredentialsProvider(credsProvider);
            }
            clientBuilder.setProxy(proxy);
        }
        this.preemptiveBasicAuth = (preemptiveBasicAuthProperty = (Boolean)config.getProperties().get("jersey.config.apache.client.preemptiveBasicAuthentication")) != null ? preemptiveBasicAuthProperty : false;
        boolean ignoreCookies = PropertiesHelper.isProperty(config.getProperties(), "jersey.config.apache.client.handleCookies");
        if (reqConfig != null) {
            RequestConfig.Builder reqConfigBuilder = RequestConfig.copy((RequestConfig)reqConfig);
            if (ignoreCookies) {
                reqConfigBuilder.setCookieSpec("ignoreCookies");
            }
            this.requestConfig = reqConfigBuilder.build();
        } else {
            if (ignoreCookies) {
                requestConfigBuilder.setCookieSpec("ignoreCookies");
            }
            this.requestConfig = requestConfigBuilder.build();
        }
        if (this.requestConfig.getCookieSpec() == null || !this.requestConfig.getCookieSpec().equals("ignoreCookies")) {
            this.cookieStore = new BasicCookieStore();
            clientBuilder.setDefaultCookieStore(this.cookieStore);
        } else {
            this.cookieStore = null;
        }
        clientBuilder.setDefaultRequestConfig(this.requestConfig);
        this.client = clientBuilder.build();
    }

    private HttpClientConnectionManager getConnectionManager(Client client, Configuration config, SSLContext sslContext) {
        Object cmObject = config.getProperties().get("jersey.config.apache.client.connectionManager");
        if (cmObject != null) {
            if (cmObject instanceof HttpClientConnectionManager) {
                return (HttpClientConnectionManager)cmObject;
            }
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.connectionManager", cmObject.getClass().getName(), HttpClientConnectionManager.class.getName()));
        }
        return this.createConnectionManager(client, config, sslContext, false);
    }

    private HttpClientConnectionManager createConnectionManager(Client client, Configuration config, SSLContext sslContext, boolean useSystemProperties) {
        String s;
        String[] supportedProtocols = useSystemProperties ? ApacheConnector.split(System.getProperty("https.protocols")) : null;
        String[] supportedCipherSuites = useSystemProperties ? ApacheConnector.split(System.getProperty("https.cipherSuites")) : null;
        HostnameVerifier hostnameVerifier = client.getHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = sslContext != null ? new SSLConnectionSocketFactory(sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (useSystemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        Integer chunkSize = ClientProperties.getValue(config.getProperties(), "jersey.config.client.chunkedEncodingSize", 4096, Integer.class);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry, new ConnectionFactory(chunkSize));
        if (useSystemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
            s = System.getProperty("http.maxConnections", "5");
            int max = Integer.parseInt(s);
            connectionManager.setDefaultMaxPerRoute(max);
            connectionManager.setMaxTotal(2 * max);
        }
        return connectionManager;
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE("jersey.config.client.proxy.uri"));
    }

    @Override
    public ClientResponse apply(ClientRequest clientRequest) throws ProcessingException {
        HttpUriRequest request = this.getUriHttpRequest(clientRequest);
        Map<String, String> clientHeadersSnapshot = ApacheConnector.writeOutBoundHeaders(clientRequest.getHeaders(), request);
        try {
            HttpClientContext context = HttpClientContext.create();
            if (this.preemptiveBasicAuth) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicScheme = new BasicScheme();
                authCache.put(this.getHost(request), basicScheme);
                context.setAuthCache(authCache);
            }
            CloseableHttpResponse response = this.client.execute(this.getHost(request), (HttpRequest)request, (HttpContext)context);
            HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, clientRequest.getHeaders(), this.getClass().getName());
            Response.StatusType status = response.getStatusLine().getReasonPhrase() == null ? Statuses.from(response.getStatusLine().getStatusCode()) : Statuses.from(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            ClientResponse responseContext = new ClientResponse(status, clientRequest);
            List<URI> redirectLocations = context.getRedirectLocations();
            if (redirectLocations != null && !redirectLocations.isEmpty()) {
                responseContext.setResolvedRequestUri(redirectLocations.get(redirectLocations.size() - 1));
            }
            Header[] respHeaders = response.getAllHeaders();
            MultivaluedMap<String, String> headers = responseContext.getHeaders();
            for (Header header : respHeaders) {
                String headerName = header.getName();
                ArrayList<String> list = (ArrayList<String>)headers.get(headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                headers.put(headerName, (String)((Object)list));
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (headers.get("Content-Length") == null) {
                    headers.add("Content-Length", String.valueOf(entity.getContentLength()));
                }
                Header contentEncoding = entity.getContentEncoding();
                if (headers.get("Content-Encoding") == null && contentEncoding != null) {
                    headers.add("Content-Encoding", contentEncoding.getValue());
                }
            }
            try {
                responseContext.setEntityStream(new HttpClientResponseInputStream(ApacheConnector.getInputStream(response)));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, null, e);
            }
            return responseContext;
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    @Override
    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(ApacheConnector.this.apply(request));
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    @Override
    public String getName() {
        return "Apache HttpClient " + release;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.FAILED_TO_STOP_CLIENT(), e);
        }
    }

    private HttpHost getHost(HttpUriRequest request) {
        return new HttpHost(request.getURI().getHost(), request.getURI().getPort(), request.getURI().getScheme());
    }

    private HttpUriRequest getUriHttpRequest(ClientRequest clientRequest) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.copy(this.requestConfig);
        int connectTimeout = clientRequest.resolveProperty("jersey.config.client.connectTimeout", -1);
        int socketTimeout = clientRequest.resolveProperty("jersey.config.client.readTimeout", -1);
        if (connectTimeout >= 0) {
            requestConfigBuilder.setConnectTimeout(connectTimeout);
        }
        if (socketTimeout >= 0) {
            requestConfigBuilder.setSocketTimeout(socketTimeout);
        }
        Boolean redirectsEnabled = clientRequest.resolveProperty("jersey.config.client.followRedirects", this.requestConfig.isRedirectsEnabled());
        requestConfigBuilder.setRedirectsEnabled(redirectsEnabled);
        Boolean bufferingEnabled = clientRequest.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class) == RequestEntityProcessing.BUFFERED;
        HttpEntity entity = this.getHttpEntity(clientRequest, bufferingEnabled);
        return RequestBuilder.create(clientRequest.getMethod()).setUri(clientRequest.getUri()).setConfig(requestConfigBuilder.build()).setEntity(entity).build();
    }

    private HttpEntity getHttpEntity(final ClientRequest clientRequest, final boolean bufferingEnabled) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(){

            @Override
            public boolean isRepeatable() {
                return false;
            }

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public InputStream getContent() throws IOException, IllegalStateException {
                if (bufferingEnabled) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
                    this.writeTo(buffer);
                    return new ByteArrayInputStream(buffer.toByteArray());
                }
                return null;
            }

            @Override
            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    @Override
                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            @Override
            public boolean isStreaming() {
                return false;
            }
        };
        if (bufferingEnabled) {
            try {
                return new BufferedHttpEntity(httpEntity);
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_BUFFERING_ENTITY(), e);
            }
        }
        return httpEntity;
    }

    private static Map<String, String> writeOutBoundHeaders(MultivaluedMap<String, Object> headers, HttpUriRequest request) {
        Map<String, String> stringHeaders = HeaderUtils.asStringHeadersSingleValue(headers);
        for (Map.Entry<String, String> e : stringHeaders.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return stringHeaders;
    }

    private static InputStream getInputStream(final CloseableHttpResponse response) throws IOException {
        InputStream i;
        InputStream inputStream = response.getEntity() == null ? new ByteArrayInputStream(new byte[0]) : ((i = response.getEntity().getContent()).markSupported() ? i : new BufferedInputStream(i, ReaderWriter.BUFFER_SIZE));
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                response.close();
                super.close();
            }
        };
    }

    private static class HttpClientConnection
    extends DefaultManagedHttpClientConnection {
        private final int chunkSize;

        private HttpClientConnection(String id, int buffersize, int chunkSize) {
            super(id, buffersize);
            this.chunkSize = chunkSize;
        }

        @Override
        protected OutputStream createOutputStream(long len, SessionOutputBuffer outbuffer) {
            if (len == -2L) {
                return new ChunkedOutputStream(this.chunkSize, outbuffer);
            }
            return super.createOutputStream(len, outbuffer);
        }
    }

    private static class ConnectionFactory
    extends ManagedHttpClientConnectionFactory {
        private static final AtomicLong COUNTER = new AtomicLong();
        private final int chunkSize;

        private ConnectionFactory(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        public ManagedHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
            String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
            return new HttpClientConnection(id, config.getBufferSize(), this.chunkSize);
        }
    }

    private static final class HttpClientResponseInputStream
    extends FilterInputStream {
        HttpClientResponseInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

