/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.integrations.pingfederate;

import com.inwebo.integrations.auth.InWeboRestAuthenticator;
import com.inwebo.integrations.auth.Property;
import com.inwebo.integrations.pingfederate.InWeboField;
import com.inwebo.integrations.pingfederate.Log4j2CustomHandler;
import com.inwebo.integrations.util.BuildProperties;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordValidationException;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.HostnameValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.LongValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.util.log.AttributeMap;

public class InWeboAuthModule
implements PasswordCredentialValidator {
    private static final RequiredFieldValidator REQUIRED_FIELD_VALIDATOR = new RequiredFieldValidator();
    private final Logger logger;
    private final PluginDescriptor descriptor;
    private Configuration configuration = null;
    private InWeboRestAuthenticator authenticator;
    private Properties inWeboProperties;

    public InWeboAuthModule() {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor("Use this plug in to integrate PingFederate with InWebo Authenticator");
        this.descriptor = new PluginDescriptor(BuildProperties.getName(), (ConfigurablePlugin)this, this.addConfigurationFields(guiDescriptor), BuildProperties.getVersion());
        this.descriptor.setAttributeContractSet(Collections.singleton("username"));
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.addHandler(new Log4j2CustomHandler());
        this.logger.setUseParentHandlers(false);
    }

    public AttributeMap processPasswordCredential(String login, String otp) throws PasswordValidationException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format("Entering in method 'processPasswordCredential'", new Object[0]));
        }
        try {
            if (StringUtils.isBlank((String)otp)) {
                return null;
            }
            if (this.authenticator.authorize(login, otp).booleanValue()) {
                AttributeMap result = new AttributeMap();
                result.put("username", login);
                return result;
            }
            return null;
        }
        catch (Exception e) {
            throw new PasswordValidationException("inWebo Plugin Error", (Throwable)e);
        }
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
        this.inWeboProperties = new Properties();
        this.addProperty(Property.SERVICE_ID, InWeboField.SERVICE_ID_FIELD_NAME);
        this.addProperty(Property.CERTIFICATE_PATH, InWeboField.CERTIFICATE_PATH_FIELD_NAME);
        this.addProperty(Property.CERTIFICATE_PASSWORD, InWeboField.CERTIFICATE_PWD_FIELD_NAME);
        this.addProperty(Property.PROXY_HOST, InWeboField.PROXY_HOSTNAME_FIELD_NAME);
        this.addProperty(Property.PROXY_PORT, InWeboField.PROXY_PORT_FIELD_NAME);
        this.addProperty(Property.PROXY_USER, InWeboField.PROXY_USERNAME_FIELD_NAME);
        this.addProperty(Property.PROXY_PASSWORD, InWeboField.PROXY_PASSWORD_FIELD_NAME);
        this.addProperty(Property.PROXY_HTTPS, InWeboField.ENABLE_PROXY_HTTPS);
        try {
            this.authenticator = new InWeboRestAuthenticator(this.inWeboProperties, this.logger);
        }
        catch (Exception e) {
            throw new PasswordValidationException("inWebo Plugin init Error", (Throwable)e);
        }
    }

    private void addProperty(Property property, InWeboField inWeboField) {
        String value = this.configuration.getFieldValue(inWeboField.getName());
        if (StringUtils.isNotBlank((String)value)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, String.format("property '%s' with value '%s'", property.key(), value));
            }
            this.inWeboProperties.putIfAbsent(property.key(), value);
        }
    }

    private GuiConfigDescriptor addConfigurationFields(GuiConfigDescriptor descriptor) {
        TextFieldDescriptor serviceIdField = new TextFieldDescriptor(InWeboField.SERVICE_ID_FIELD_NAME.getName(), InWeboField.SERVICE_ID_FIELD_NAME.getDescription());
        serviceIdField.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        serviceIdField.addValidator((FieldValidator)new LongValidator(2L, Long.MAX_VALUE));
        descriptor.addField((FieldDescriptor)serviceIdField);
        TextFieldDescriptor certPathField = new TextFieldDescriptor(InWeboField.CERTIFICATE_PATH_FIELD_NAME.getName(), InWeboField.CERTIFICATE_PATH_FIELD_NAME.getDescription());
        certPathField.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        descriptor.addField((FieldDescriptor)certPathField);
        TextFieldDescriptor certPwdField = new TextFieldDescriptor(InWeboField.CERTIFICATE_PWD_FIELD_NAME.getName(), InWeboField.CERTIFICATE_PWD_FIELD_NAME.getDescription(), true);
        certPwdField.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        descriptor.addField((FieldDescriptor)certPwdField);
        TextFieldDescriptor proxyHostField = new TextFieldDescriptor(InWeboField.PROXY_HOSTNAME_FIELD_NAME.getName(), InWeboField.PROXY_HOSTNAME_FIELD_NAME.getDescription());
        proxyHostField.addValidator((FieldValidator)new HostnameValidator(), true);
        descriptor.addAdvancedField((FieldDescriptor)proxyHostField);
        TextFieldDescriptor proxyPortField = new TextFieldDescriptor(InWeboField.PROXY_PORT_FIELD_NAME.getName(), InWeboField.PROXY_PORT_FIELD_NAME.getDescription());
        proxyPortField.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        descriptor.addAdvancedField((FieldDescriptor)proxyPortField);
        TextFieldDescriptor proxyUserNameField = new TextFieldDescriptor(InWeboField.PROXY_USERNAME_FIELD_NAME.getName(), InWeboField.PROXY_USERNAME_FIELD_NAME.getDescription());
        descriptor.addAdvancedField((FieldDescriptor)proxyUserNameField);
        TextFieldDescriptor proxyPwdField = new TextFieldDescriptor(InWeboField.PROXY_PASSWORD_FIELD_NAME.getName(), InWeboField.PROXY_PASSWORD_FIELD_NAME.getDescription(), true);
        descriptor.addAdvancedField((FieldDescriptor)proxyPwdField);
        CheckBoxFieldDescriptor enableProxyHttps = new CheckBoxFieldDescriptor(InWeboField.ENABLE_PROXY_HTTPS.getName(), InWeboField.ENABLE_PROXY_HTTPS.getDescription());
        enableProxyHttps.setDefaultValue(false);
        enableProxyHttps.setDefaultForLegacyConfig(Boolean.toString(false));
        descriptor.addAdvancedField((FieldDescriptor)enableProxyHttps);
        return descriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }
}

