/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.jersey.core.impl.provider.entity;

import com.inwebo.repackaged.javax.ws.rs.core.MediaType;
import com.inwebo.repackaged.javax.ws.rs.core.MultivaluedMap;
import com.inwebo.repackaged.jersey.core.provider.AbstractMessageReaderWriterProvider;
import com.inwebo.repackaged.jersey.core.util.ReaderWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFormProvider<T extends MultivaluedMap<String, String>>
extends AbstractMessageReaderWriterProvider<T> {
    public T readFrom(T map, MediaType mediaType, InputStream entityStream) throws IOException {
        String encoded = BaseFormProvider.readFromAsString(entityStream, mediaType);
        String charsetName = ReaderWriter.getCharset(mediaType).name();
        StringTokenizer tokenizer = new StringTokenizer(encoded, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.add((String)URLDecoder.decode(token, charsetName), null);
                continue;
            }
            if (idx <= 0) continue;
            map.add((String)URLDecoder.decode(token.substring(0, idx), charsetName), (String)URLDecoder.decode(token.substring(idx + 1), charsetName));
        }
        return map;
    }

    public void writeTo(T t, MediaType mediaType, OutputStream entityStream) throws IOException {
        String charsetName = ReaderWriter.getCharset(mediaType).name();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : t.entrySet()) {
            for (String value : (List)e.getValue()) {
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(URLEncoder.encode((String)e.getKey(), charsetName));
                if (value == null) continue;
                sb.append('=');
                sb.append(URLEncoder.encode(value, charsetName));
            }
        }
        BaseFormProvider.writeToAsString(sb.toString(), entityStream, mediaType);
    }
}

