/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.inwebo;

import com.inwebo.repackaged.json.simple.JSONObject;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.forgerock.openam.inwebo.InWeboAuthPrincipal;
import org.forgerock.openam.inwebo.InWeboRestAuthenticator;

public class InWeboAuth
extends AMLoginModule {
    private static final Debug debug = Debug.getInstance((String)"InWeboAuth");
    private static final String amAuthInweboAuth = "amAuthInWeboAuth";
    private static final int STATE_BEGIN = 1;
    private static final int STATE_AUTH = 2;
    private static final int STATE_ERROR = 3;
    private static final String ACTIVE_VALUE = "Active";
    private static final String BROWSER_AUTHENTICATOR = "BROWSER";
    private static final String PUSH_AUTHENTICATOR = "PUSH";
    private static final String INWEBO_AUTH_TYPE_PARAM_NAME = "inWeboAuthType";
    private static final String BASIC_AUTHENTICATOR = "OTP";
    private static final String INWEBO_BROWSER_ALIAS_PARAM_NAME = "inWeboBrowserAlias";
    private static final String INWEBO_PUSH_ACTIVATE_PARAM_NAME = "inWeboPushActivate";
    private static final String INWEBO_SHARED_USER_NAME_PARAM_NAME = "inWeboSharedUserName";
    private Map options;
    private ResourceBundle bundle;
    private InWeboRestAuthenticator auth;
    private String sharedUserName;
    private String browserAlias;
    private boolean isBrowserAuthenticate;
    private boolean isPushAuthenticate;
    private Map sharedState;

    public void init(Subject subject, Map sharedState, Map options) {
        block5: {
            if (debug.messageEnabled()) {
                debug.message("InWeboAuthModule::init");
            }
            try {
                this.options = options;
                this.sharedState = sharedState;
                this.bundle = amCache.getResBundle(amAuthInweboAuth, this.getLoginLocale());
                this.isBrowserAuthenticate = this.getBooleanMapAttr("iplanet-am-auth-inweboauth-browser-authenticator");
                this.isPushAuthenticate = this.getBooleanMapAttr("iplanet-am-auth-inweboauth-push-authenticator");
                if (this.isBrowserAuthenticate || this.isPushAuthenticate) {
                    this.browserAlias = CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-inweboauth-browser-alias");
                }
                int serviceId = CollectionHelper.getIntMapAttr((Map)options, (String)"iplanet-am-auth-inweboauth-serviceid", (int)0, (Debug)debug);
                String certificatePath = CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-inweboauth-certificate-path");
                String certificatePassword = CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-inweboauth-certificate-password");
                this.auth = new InWeboRestAuthenticator(serviceId, certificatePath, certificatePassword);
                if (debug.messageEnabled()) {
                    debug.message("InWeboAuthModule::init - serviceId '{}', isBrowserAuthenticate '{}', browserAlias '{}', isPushAuthenticate '{}', certificatePath '{}'", new Object[]{serviceId, this.isBrowserAuthenticate, this.browserAlias, this.isPushAuthenticate, certificatePath});
                }
            }
            catch (Exception e) {
                if (!debug.errorEnabled()) break block5;
                debug.error("InWeboAuthModule::init - Internal Error", (Throwable)e);
            }
        }
    }

    public int process(Callback[] callbacks, int state) throws LoginException {
        if (debug.messageEnabled()) {
            debug.message("InWeboAuthModule::process - state: '{}'", new Object[]{state});
        }
        try {
            HttpServletRequest request = this.setRequestForLegacyUI();
            switch (state) {
                case 1: {
                    if (debug.messageEnabled()) {
                        debug.message("InWeboAuthModule::begin - start");
                    }
                    this.log(request);
                    this.substituteUIStrings();
                    return 2;
                }
                case 2: {
                    this.log(request);
                    String authType = this.getAuthType(callbacks, request);
                    if (BROWSER_AUTHENTICATOR.equals(authType)) {
                        return this.authenticateExtendedValidator(callbacks, BROWSER_AUTHENTICATOR);
                    }
                    if (BASIC_AUTHENTICATOR.equals(authType)) {
                        return this.authenticateExtendedValidator(callbacks, BASIC_AUTHENTICATOR);
                    }
                    if (debug.errorEnabled()) {
                        debug.error("InWeboAuthModule::auth - invalid inWeboAuthType '{}'", new Object[]{authType});
                    }
                    throw new InvalidPasswordException("Access Denied");
                }
                case 3: {
                    this.setErrorText("inwebo.i18n.ui.error-1");
                    return 3;
                }
            }
            if (debug.errorEnabled()) {
                debug.error("InWeboAuthModule::process - invalid state");
            }
            throw new AuthLoginException("InWeboAuthModule::process - invalid state");
        }
        catch (Exception e) {
            if (debug.errorEnabled()) {
                debug.error("InWeboAuthModule::process - UNKNOWN ERROR", (Throwable)e);
            }
            throw new AuthLoginException("InWeboAuthModule::process - UNKNOWN ERROR", (Throwable)e);
        }
    }

    private String getAuthType(Callback[] callbacks, HttpServletRequest request) {
        String authType = request.getParameter(INWEBO_AUTH_TYPE_PARAM_NAME);
        if (null == authType && callbacks != null && callbacks.length > 2) {
            authType = ((NameCallback)NameCallback.class.cast(callbacks[2])).getName();
        }
        return authType;
    }

    public Principal getPrincipal() {
        return new InWeboAuthPrincipal(this.sharedUserName);
    }

    private HttpServletRequest setRequestForLegacyUI() {
        String userName;
        HttpServletRequest request = this.getHttpServletRequest();
        String inWeboAuthType = String.valueOf(request.getAttribute(INWEBO_AUTH_TYPE_PARAM_NAME));
        if (inWeboAuthType == null || "null".equals(inWeboAuthType)) {
            if (this.isBrowserAuthenticate) {
                request.setAttribute(INWEBO_AUTH_TYPE_PARAM_NAME, (Object)BROWSER_AUTHENTICATOR);
                request.setAttribute(INWEBO_BROWSER_ALIAS_PARAM_NAME, (Object)this.browserAlias);
                request.setAttribute(INWEBO_PUSH_ACTIVATE_PARAM_NAME, (Object)String.valueOf(this.isPushAuthenticate));
            } else if (this.isPushAuthenticate) {
                request.setAttribute(INWEBO_AUTH_TYPE_PARAM_NAME, (Object)PUSH_AUTHENTICATOR);
            }
        }
        if (StringUtils.isNotBlank((String)(userName = this.getSharedUserName()))) {
            request.setAttribute(INWEBO_SHARED_USER_NAME_PARAM_NAME, (Object)userName);
        }
        return request;
    }

    private boolean getBooleanMapAttr(String key) {
        String value = CollectionHelper.getMapAttr((Map)this.options, (String)key, (String)ACTIVE_VALUE);
        return ACTIVE_VALUE.equalsIgnoreCase(value);
    }

    private void setErrorText(String err) throws AuthLoginException {
        this.substituteHeader(3, this.bundle.getString(err));
    }

    private void substituteUIStrings() throws AuthLoginException {
        this.substituteHeader(2, this.bundle.getString("inwebo.i18n.ui.login.header"));
        String userName = this.getSharedUserName();
        if (debug.messageEnabled()) {
            debug.message("InWeboAuthModule::begin - sharedUserName '{}'", new Object[]{userName});
        }
        NameCallback userNameCallBack = new NameCallback(this.bundle.getString("inwebo.i18n.ui.login.username.prompt"));
        if (StringUtils.isNotBlank((String)userName)) {
            userNameCallBack.setName(userName);
        }
        this.replaceCallback(2, 0, userNameCallBack);
        this.replaceCallback(2, 1, new PasswordCallback(this.bundle.getString("inwebo.i18n.ui.login.password.prompt"), false));
        if (this.isBrowserAuthenticate) {
            this.replaceCallback(2, 2, new NameCallback(BROWSER_AUTHENTICATOR));
            this.replaceCallback(2, 3, new NameCallback(this.browserAlias));
            this.replaceCallback(2, 4, new NameCallback(String.valueOf(this.isPushAuthenticate)));
        } else if (this.isPushAuthenticate) {
            this.replaceCallback(2, 2, new NameCallback(PUSH_AUTHENTICATOR));
            this.replaceCallback(2, 3, new NameCallback(this.browserAlias));
        } else {
            this.replaceCallback(2, 2, new NameCallback(BASIC_AUTHENTICATOR));
        }
    }

    private String getSharedUserName() {
        return (String)String.class.cast(this.sharedState.get(this.getUserKey()));
    }

    private void log(HttpServletRequest request) {
        if (debug.messageEnabled()) {
            for (String name : Collections.list(request.getParameterNames())) {
                String value = request.getParameter(name);
                debug.message("InWeboAuthModule::auth - paramName '{}' ; paramValue '{}'", new Object[]{name, value});
            }
        }
    }

    private int authenticateExtendedValidator(Callback[] callbacks, String inWeboAuthType) throws InvalidPasswordException {
        NameCallback nc = (NameCallback)NameCallback.class.cast(callbacks[0]);
        PasswordCallback pc = (PasswordCallback)PasswordCallback.class.cast(callbacks[1]);
        this.sharedUserName = this.getUserName(nc);
        String password = new String(pc.getPassword());
        JSONObject result = this.auth.authenticate(this.sharedUserName, password);
        if (result != null && "OK".equals(result.get("err"))) {
            if (debug.messageEnabled()) {
                debug.message("InWeboAuthModule::auth - Login by '{}' with {} Authenticator succeeded", new Object[]{this.sharedUserName, inWeboAuthType});
            }
            return -1;
        }
        if (debug.errorEnabled()) {
            debug.error("InWeboAuthModule::auth - Login by '{}' with {} Authenticator failed with result '{}'", new Object[]{this.sharedUserName, inWeboAuthType, result});
        }
        throw new InvalidPasswordException("Access Denied", this.sharedUserName);
    }

    private String getUserName(NameCallback nc) {
        String userName = this.getSharedUserName();
        if (userName == null || userName.isEmpty()) {
            userName = nc.getName();
        }
        return userName;
    }

    public void destroyModuleState() {
        this.sharedUserName = null;
    }
}

