/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl;

import com.inwebo.repackaged.apache.commons.httpclient.ConnectTimeoutException;
import com.inwebo.repackaged.apache.commons.httpclient.params.HttpConnectionParams;
import com.inwebo.repackaged.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import com.inwebo.repackaged.apache.commons.logging.Log;
import com.inwebo.repackaged.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class StrictSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory = StrictSSLProtocolSocketFactory.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory);
    private boolean verifyHostname = true;
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory;

    public StrictSSLProtocolSocketFactory(boolean bl) {
        this.verifyHostname = bl;
    }

    public StrictSSLProtocolSocketFactory() {
    }

    public void setHostnameVerification(boolean bl) {
        this.verifyHostname = bl;
    }

    public boolean getHostnameVerification() {
        return this.verifyHostname;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        this.verifyHostname(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        Socket socket = null;
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        if (n3 == 0) {
            socket = socketFactory.createSocket(string, n, inetAddress, n2);
        } else {
            socket = socketFactory.createSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
            socket.bind(inetSocketAddress);
            socket.connect(inetSocketAddress2, n3);
        }
        this.verifyHostname((SSLSocket)socket);
        return socket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        this.verifyHostname(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, bl);
        this.verifyHostname(sSLSocket);
        return sSLSocket;
    }

    private void verifyHostname(SSLSocket sSLSocket) throws SSLPeerUnverifiedException, UnknownHostException {
        String string;
        X509Certificate[] x509CertificateArray;
        if (!this.verifyHostname) {
            return;
        }
        SSLSession sSLSession = sSLSocket.getSession();
        String string2 = sSLSession.getPeerHost();
        try {
            x509CertificateArray = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new UnknownHostException("Could not resolve SSL sessions server hostname: " + string2);
        }
        x509CertificateArray = sSLSession.getPeerCertificateChain();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new SSLPeerUnverifiedException("No server certificates found!");
        }
        String string3 = x509CertificateArray[0].getSubjectDN().getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                LOG.debug("X509Certificate[" + i + "]=" + x509CertificateArray[i]);
            }
        }
        if (string2.equalsIgnoreCase(string = this.getCN(string3))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target hostname valid: " + string);
            }
        } else {
            throw new SSLPeerUnverifiedException("HTTPS hostname invalid: expected '" + string2 + "', received '" + string + "'");
        }
    }

    private String getCN(String string) {
        int n = 0;
        n = string.indexOf("CN=");
        if (n == -1) {
            return null;
        }
        string = string.substring(n + 3);
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length && (cArray[n] != ',' || n <= 0 || cArray[n - 1] == '\\'); ++n) {
        }
        return string.substring(0, n);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory = StrictSSLProtocolSocketFactory.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory)) {
            return ((StrictSSLProtocolSocketFactory)object).getHostnameVerification() == this.verifyHostname;
        }
        return false;
    }

    public int hashCode() {
        return (class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory = StrictSSLProtocolSocketFactory.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$StrictSSLProtocolSocketFactory).hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

