/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.jersey.core.provider.jaxb;

import com.inwebo.repackaged.javax.ws.rs.core.Context;
import com.inwebo.repackaged.javax.ws.rs.core.MediaType;
import com.inwebo.repackaged.javax.ws.rs.ext.ContextResolver;
import com.inwebo.repackaged.javax.ws.rs.ext.Providers;
import com.inwebo.repackaged.jersey.core.provider.AbstractMessageReaderWriterProvider;
import com.inwebo.repackaged.jersey.core.util.FeaturesAndProperties;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider<T>
extends AbstractMessageReaderWriterProvider<T> {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private final Providers ps;
    private final boolean fixedMediaType;
    private final ContextResolver<JAXBContext> mtContext;
    private final ContextResolver<Unmarshaller> mtUnmarshaller;
    private final ContextResolver<Marshaller> mtMarshaller;
    private boolean formattedOutput = false;

    public AbstractJAXBProvider(Providers ps) {
        this(ps, null);
    }

    public AbstractJAXBProvider(Providers ps, MediaType mt) {
        this.ps = ps;
        boolean bl = this.fixedMediaType = mt != null;
        if (this.fixedMediaType) {
            this.mtContext = ps.getContextResolver(JAXBContext.class, mt);
            this.mtUnmarshaller = ps.getContextResolver(Unmarshaller.class, mt);
            this.mtMarshaller = ps.getContextResolver(Marshaller.class, mt);
        } else {
            this.mtContext = null;
            this.mtUnmarshaller = null;
            this.mtMarshaller = null;
        }
    }

    @Context
    public void setConfiguration(FeaturesAndProperties fp) {
        this.formattedOutput = fp.getFeature("com.inwebo.repackaged.jersey.config.feature.Formatted");
    }

    protected boolean isSupported(MediaType m) {
        return true;
    }

    protected final Unmarshaller getUnmarshaller(Class type, MediaType mt) throws JAXBException {
        Unmarshaller u;
        if (this.fixedMediaType) {
            return this.getUnmarshaller(type);
        }
        ContextResolver<Unmarshaller> uncr = this.ps.getContextResolver(Unmarshaller.class, mt);
        if (uncr != null && (u = uncr.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type, mt).createUnmarshaller();
    }

    private final Unmarshaller getUnmarshaller(Class type) throws JAXBException {
        Unmarshaller u;
        if (this.mtUnmarshaller != null && (u = this.mtUnmarshaller.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type).createUnmarshaller();
    }

    protected final Marshaller getMarshaller(Class type, MediaType mt) throws JAXBException {
        Marshaller m;
        if (this.fixedMediaType) {
            return this.getMarshaller(type);
        }
        ContextResolver<Marshaller> mcr = this.ps.getContextResolver(Marshaller.class, mt);
        if (mcr != null && (m = mcr.getContext(type)) != null) {
            return m;
        }
        m = this.getJAXBContext(type, mt).createMarshaller();
        if (this.formattedOutput) {
            m.setProperty("jaxb.formatted.output", (Object)this.formattedOutput);
        }
        return m;
    }

    private final Marshaller getMarshaller(Class type) throws JAXBException {
        Marshaller u;
        if (this.mtMarshaller != null && (u = this.mtMarshaller.getContext(type)) != null) {
            return u;
        }
        Marshaller m = this.getJAXBContext(type).createMarshaller();
        if (this.formattedOutput) {
            m.setProperty("jaxb.formatted.output", (Object)this.formattedOutput);
        }
        return m;
    }

    private final JAXBContext getJAXBContext(Class type, MediaType mt) throws JAXBException {
        JAXBContext c;
        ContextResolver<JAXBContext> cr = this.ps.getContextResolver(JAXBContext.class, mt);
        if (cr != null && (c = cr.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    private final JAXBContext getJAXBContext(Class type) throws JAXBException {
        JAXBContext c;
        if (this.mtContext != null && (c = this.mtContext.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = jaxbContexts.get(type);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, c);
            }
            return c;
        }
    }

    protected static SAXSource getSAXSource(SAXParserFactory spf, InputStream entityStream) throws JAXBException {
        try {
            return new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(entityStream));
        }
        catch (Exception ex) {
            throw new JAXBException("Error creating SAXSource", (Throwable)ex);
        }
    }

    protected boolean getFormattedOutput() {
        return this.formattedOutput;
    }
}

