/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl;

import com.inwebo.repackaged.apache.commons.httpclient.ConnectTimeoutException;
import com.inwebo.repackaged.apache.commons.httpclient.HttpClientError;
import com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.EasyX509TrustManager;
import com.inwebo.repackaged.apache.commons.httpclient.params.HttpConnectionParams;
import com.inwebo.repackaged.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import com.inwebo.repackaged.apache.commons.logging.Log;
import com.inwebo.repackaged.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class EasySSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory = EasySSLProtocolSocketFactory.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory);
    private SSLContext sslcontext = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory;

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, null);
            return sSLContext;
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), exception);
            throw new HttpClientError(exception.toString());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = EasySSLProtocolSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.getSSLContext().getSocketFactory();
        if (n3 == 0) {
            return sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
        socket.bind(inetSocketAddress);
        socket.connect(inetSocketAddress2, n3);
        return socket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory = EasySSLProtocolSocketFactory.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory);
    }

    public int hashCode() {
        return (class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory = EasySSLProtocolSocketFactory.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$EasySSLProtocolSocketFactory).hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

