/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.inwebo;

import com.inwebo.repackaged.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import com.inwebo.repackaged.apache.commons.httpclient.HostConfiguration;
import com.inwebo.repackaged.apache.commons.httpclient.HttpClient;
import com.inwebo.repackaged.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import com.inwebo.repackaged.apache.commons.httpclient.UsernamePasswordCredentials;
import com.inwebo.repackaged.apache.commons.httpclient.auth.AuthScope;
import com.inwebo.repackaged.apache.commons.httpclient.params.HttpConnectionManagerParams;
import com.inwebo.repackaged.apache.commons.httpclient.protocol.Protocol;
import com.inwebo.repackaged.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import com.inwebo.repackaged.apache.commons.logging.Log;
import com.inwebo.repackaged.apache.commons.logging.LogFactory;
import com.inwebo.repackaged.javax.ws.rs.core.MediaType;
import com.inwebo.repackaged.javax.ws.rs.core.Response;
import com.inwebo.repackaged.jersey.api.client.Client;
import com.inwebo.repackaged.jersey.api.client.ClientHandler;
import com.inwebo.repackaged.jersey.api.client.ClientResponse;
import com.inwebo.repackaged.jersey.api.client.config.ClientConfig;
import com.inwebo.repackaged.jersey.client.apache.ApacheHttpClient;
import com.inwebo.repackaged.jersey.client.apache.ApacheHttpClientHandler;
import com.inwebo.repackaged.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.inwebo.repackaged.json.simple.JSONObject;
import com.inwebo.repackaged.json.simple.parser.JSONParser;
import com.inwebo.repackaged.json.simple.parser.ParseException;
import org.forgerock.openam.inwebo.InWeboAuthSSLProtocolSocketFactory;

public class InWeboRestAuthenticator {
    public static final String DEBUG_NAME = "InWeboAuth";
    public static final String RESULT_CODE_OK = "OK";
    private static final Log LOG = LogFactory.getLog("InWeboAuth");
    private static final String INWEBO_BASE_URL = "https://api.myinwebo.com/FS";
    private static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_HTTP_READ_TIMEOUT = 60000;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_HOST = 20;
    private static final int DEFAULT_HTTP_MAX_CONNECTIONS = 22;
    private static final String HTTPS = "https";
    private static final int HTTPS_DEFAULT_PORT = 443;
    private final long serviceId;
    private final ClientHandler root;
    private final ClientConfig config;

    public InWeboRestAuthenticator(long serviceId, String p12file, String p12password) throws Exception {
        this.serviceId = serviceId;
        this.registerInWeboApiCertificateSocketFactory(p12file, p12password);
        ApacheHttpClientHandler clientHandler = new ApacheHttpClientHandler(this.httpClient());
        this.root = new ApacheHttpClient(clientHandler);
        this.config = new DefaultApacheHttpClientConfig();
    }

    private void registerInWeboApiCertificateSocketFactory(String p12file, String p12password) throws Exception {
        InWeboAuthSSLProtocolSocketFactory socketFactory = new InWeboAuthSSLProtocolSocketFactory(p12file, p12password);
        Protocol.registerProtocol(HTTPS, new Protocol(HTTPS, (ProtocolSocketFactory)socketFactory, 443));
    }

    private MultiThreadedHttpConnectionManager connectionManager() throws Exception {
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams pars = multiThreadedHttpConnectionManager.getParams();
        pars.setConnectionTimeout(10000);
        pars.setSoTimeout(60000);
        pars.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
        pars.setMaxTotalConnections(22);
        pars.setDefaultMaxConnectionsPerHost(20);
        return multiThreadedHttpConnectionManager;
    }

    private HttpClient httpClient() throws Exception {
        HttpClient httpClient = new HttpClient(this.connectionManager());
        this.initProxy(httpClient);
        return httpClient;
    }

    private void initProxy(HttpClient httpClient) {
        String proxyPort;
        String proxyHost = System.getProperty("https.proxyHost") != null ? System.getProperty("https.proxyHost") : System.getProperty("http.proxyHost");
        String string = proxyPort = System.getProperty("https.proxyPort") != null ? System.getProperty("https.proxyPort") : System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            String proxyPassword;
            HostConfiguration config = httpClient.getHostConfiguration();
            config.setProxy(proxyHost, Integer.valueOf(proxyPort));
            String proxyUser = System.getProperty("https.proxyUser") != null ? System.getProperty("https.proxyUser") : System.getProperty("http.proxyUser");
            String string2 = proxyPassword = System.getProperty("https.proxyPassword") != null ? System.getProperty("https.proxyPassword") : System.getProperty("http.proxyPassword");
            if (proxyUser != null && proxyPassword != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                AuthScope authScope = new AuthScope(proxyHost, Integer.valueOf(proxyPort));
                httpClient.getState().setProxyCredentials(authScope, credentials);
            }
            httpClient.setHostConfiguration(config);
        } else {
            LOG.info("InWeboAuthModule::auth - no proxy configured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject authenticate(String login, String token) {
        Client client = null;
        try {
            client = new Client(this.root, this.config);
            ClientResponse response = client.resource(INWEBO_BASE_URL).queryParam("action", "authenticateExtended").queryParam("serviceId", String.valueOf(this.serviceId)).queryParam("userId", login).queryParam("token", token).queryParam("format", "json").type(MediaType.APPLICATION_JSON_TYPE).get(ClientResponse.class);
            JSONObject jSONObject = this.getJsonObject(response);
            return jSONObject;
        }
        finally {
            if (client != null) {
                client.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getJsonObject(ClientResponse response) {
        if (response != null && response.getClientResponseStatus() != null && response.getClientResponseStatus().getFamily() == Response.Status.Family.SUCCESSFUL) {
            try {
                var2_2 = (JSONObject)JSONObject.class.cast(new JSONParser().parse(response.getEntity(String.class)));
                return var2_2;
            }
            catch (ParseException var2_3) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_4 = null;
                    return var2_4;
                }
            }
        }
        status = response.getClientResponseStatus() == null ? "UNKNOWN" : String.valueOf(response.getClientResponseStatus().getStatusCode());
        InWeboRestAuthenticator.LOG.error("InWeboAuthModule::auth - InWebo API Error with response status code: " + status);
        ** while (true)
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception var3_5) {}
            }
        }
    }
}

