/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.jersey.client.apache;

import com.inwebo.repackaged.apache.commons.httpclient.HttpClient;
import com.inwebo.repackaged.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import com.inwebo.repackaged.jersey.api.client.Client;
import com.inwebo.repackaged.jersey.api.client.config.ClientConfig;
import com.inwebo.repackaged.jersey.api.client.config.DefaultClientConfig;
import com.inwebo.repackaged.jersey.client.apache.ApacheHttpClientHandler;
import com.inwebo.repackaged.jersey.core.spi.component.ioc.IoCComponentProviderFactory;

public class ApacheHttpClient
extends Client {
    private ApacheHttpClientHandler clientHandler;

    public ApacheHttpClient() {
        this(ApacheHttpClient.createDefaultClientHander(), (ClientConfig)new DefaultClientConfig(), null);
    }

    public ApacheHttpClient(ApacheHttpClientHandler root) {
        this(root, (ClientConfig)new DefaultClientConfig(), null);
    }

    public ApacheHttpClient(ApacheHttpClientHandler root, ClientConfig config) {
        this(root, config, null);
    }

    public ApacheHttpClient(ApacheHttpClientHandler root, ClientConfig config, IoCComponentProviderFactory provider) {
        super(root, config, provider);
        this.clientHandler = root;
        HttpClient client = root.getHttpClient();
        client.getParams().setAuthenticationPreemptive(config.getPropertyAsFeature("com.inwebo.repackaged.jersey.impl.client.httpclient.preemptiveAuthentication"));
        Integer connectTimeout = (Integer)config.getProperty("com.inwebo.repackaged.jersey.client.property.connectTimeout");
        if (connectTimeout != null) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeout);
        }
    }

    public ApacheHttpClientHandler getClientHandler() {
        return this.clientHandler;
    }

    public static ApacheHttpClient create() {
        return new ApacheHttpClient(ApacheHttpClient.createDefaultClientHander());
    }

    public static ApacheHttpClient create(ClientConfig cc) {
        return new ApacheHttpClient(ApacheHttpClient.createDefaultClientHander(), cc);
    }

    public static ApacheHttpClient create(ClientConfig cc, IoCComponentProviderFactory provider) {
        return new ApacheHttpClient(ApacheHttpClient.createDefaultClientHander(), cc, provider);
    }

    private static ApacheHttpClientHandler createDefaultClientHander() {
        HttpClient client = new HttpClient(new MultiThreadedHttpConnectionManager());
        return new ApacheHttpClientHandler(client);
    }
}

