/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.apache.commons.httpclient.methods;

import com.inwebo.repackaged.apache.commons.httpclient.HttpConnection;
import com.inwebo.repackaged.apache.commons.httpclient.HttpException;
import com.inwebo.repackaged.apache.commons.httpclient.HttpState;
import com.inwebo.repackaged.apache.commons.httpclient.methods.ExpectContinueMethod;
import com.inwebo.repackaged.apache.commons.httpclient.methods.multipart.FilePart;
import com.inwebo.repackaged.apache.commons.httpclient.methods.multipart.Part;
import com.inwebo.repackaged.apache.commons.httpclient.methods.multipart.StringPart;
import com.inwebo.repackaged.apache.commons.logging.Log;
import com.inwebo.repackaged.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultipartPostMethod
extends ExpectContinueMethod {
    public static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$methods$MultipartPostMethod == null ? (class$org$apache$commons$httpclient$methods$MultipartPostMethod = MultipartPostMethod.class$("com.inwebo.repackaged.apache.commons.httpclient.methods.MultipartPostMethod")) : class$org$apache$commons$httpclient$methods$MultipartPostMethod);
    private final List parameters = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$MultipartPostMethod;

    public MultipartPostMethod() {
    }

    public MultipartPostMethod(String uri) {
        super(uri);
    }

    protected boolean hasRequestContent() {
        return true;
    }

    public String getName() {
        return "POST";
    }

    public void addParameter(String parameterName, String parameterValue) {
        LOG.trace("enter addParameter(String parameterName, String parameterValue)");
        StringPart param = new StringPart(parameterName, parameterValue);
        this.parameters.add(param);
    }

    public void addParameter(String parameterName, File parameterFile) throws FileNotFoundException {
        LOG.trace("enter MultipartPostMethod.addParameter(String parameterName, File parameterFile)");
        FilePart param = new FilePart(parameterName, parameterFile);
        this.parameters.add(param);
    }

    public void addParameter(String parameterName, String fileName, File parameterFile) throws FileNotFoundException {
        LOG.trace("enter MultipartPostMethod.addParameter(String parameterName, String fileName, File parameterFile)");
        FilePart param = new FilePart(parameterName, fileName, parameterFile);
        this.parameters.add(param);
    }

    public void addPart(Part part) {
        LOG.trace("enter addPart(Part part)");
        this.parameters.add(part);
    }

    public Part[] getParts() {
        return this.parameters.toArray(new Part[this.parameters.size()]);
    }

    protected void addContentLengthRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter EntityEnclosingMethod.addContentLengthRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("Content-Length") == null) {
            long len = this.getRequestContentLength();
            this.addRequestHeader("Content-Length", String.valueOf(len));
        }
        this.removeRequestHeader("Transfer-Encoding");
    }

    protected void addContentTypeRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter EntityEnclosingMethod.addContentTypeRequestHeader(HttpState, HttpConnection)");
        if (!this.parameters.isEmpty()) {
            StringBuffer buffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
            if (Part.getBoundary() != null) {
                buffer.append("; boundary=");
                buffer.append(Part.getBoundary());
            }
            this.setRequestHeader("Content-Type", buffer.toString());
        }
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter MultipartPostMethod.addRequestHeaders(HttpState state, HttpConnection conn)");
        super.addRequestHeaders(state, conn);
        this.addContentLengthRequestHeader(state, conn);
        this.addContentTypeRequestHeader(state, conn);
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter MultipartPostMethod.writeRequestBody(HttpState state, HttpConnection conn)");
        OutputStream out = conn.getRequestOutputStream();
        Part.sendParts(out, this.getParts());
        return true;
    }

    protected long getRequestContentLength() throws IOException {
        LOG.trace("enter MultipartPostMethod.getRequestContentLength()");
        return Part.getLengthOfParts(this.getParts());
    }

    public void recycle() {
        LOG.trace("enter MultipartPostMethod.recycle()");
        super.recycle();
        this.parameters.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

