/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl;

import com.inwebo.repackaged.apache.commons.httpclient.ConnectTimeoutException;
import com.inwebo.repackaged.apache.commons.httpclient.params.HttpConnectionParams;
import com.inwebo.repackaged.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryWrapper
implements SecureProtocolSocketFactory {
    private SSLSocketFactory socketFactory;

    public SocketFactoryWrapper(SSLSocketFactory sSLSocketFactory) {
        this.socketFactory = sSLSocketFactory;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(string, n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket socket;
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        if (n3 == 0) {
            socket = this.socketFactory.createSocket(string, n, inetAddress, n2);
        } else {
            socket = this.socketFactory.createSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
            socket.bind(inetSocketAddress);
            socket.connect(inetSocketAddress2, n3);
        }
        return socket;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(socket, string, n, bl);
    }
}

