/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.inwebo;

import com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.AuthSSLInitializationError;
import com.inwebo.repackaged.apache.commons.httpclient.params.HttpConnectionParams;
import com.inwebo.repackaged.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import com.inwebo.repackaged.apache.commons.logging.Log;
import com.inwebo.repackaged.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class InWeboAuthSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(InWeboAuthSSLProtocolSocketFactory.class);
    private SSLContext sslcontext = null;
    private final String p12file;
    private final String p12password;

    public InWeboAuthSSLProtocolSocketFactory(String p12file, String p12password) {
        this.p12file = p12file;
        this.p12password = p12password;
    }

    private InputStream getCertificateFile(String certificateFile) throws Exception {
        if (Files.exists(Paths.get(certificateFile, new String[0]), new LinkOption[0])) {
            return Files.newInputStream(Paths.get(certificateFile, new String[0]), new OpenOption[0]);
        }
        InputStream inputStream = InWeboAuthSSLProtocolSocketFactory.class.getResourceAsStream(certificateFile);
        if (inputStream == null) {
            inputStream = InWeboAuthSSLProtocolSocketFactory.class.getClassLoader().getResourceAsStream(certificateFile);
        }
        return inputStream;
    }

    private SSLContext createSSLContext() {
        InputStream keyInput = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyInput = this.getCertificateFile(this.p12file);
            keyStore.load(keyInput, this.p12password.toCharArray());
            keyManagerFactory.init(keyStore, this.p12password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            SSLContext sSLContext = context;
            return sSLContext;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage(), e);
            throw new AuthSSLInitializationError("Unsupported algorithm exception: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            LOG.error(e.getMessage(), e);
            throw new AuthSSLInitializationError("Keystore exception: " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            LOG.error(e.getMessage(), e);
            throw new AuthSSLInitializationError("Key management exception: " + e.getMessage());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            throw new AuthSSLInitializationError("I/O error reading p12 file: " + e.getMessage());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new AuthSSLInitializationError("I/O error reading p12 file: " + e.getMessage());
        }
        finally {
            if (keyInput != null) {
                try {
                    keyInput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

