/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.jersey.core.impl.provider.header;

import com.inwebo.repackaged.javax.ws.rs.core.EntityTag;
import com.inwebo.repackaged.jersey.core.header.reader.HttpHeaderReader;
import com.inwebo.repackaged.jersey.core.impl.provider.header.WriterUtil;
import com.inwebo.repackaged.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTagProvider
implements HeaderDelegateProvider<EntityTag> {
    @Override
    public boolean supports(Class<?> type) {
        return type == EntityTag.class;
    }

    @Override
    public String toString(EntityTag header) {
        StringBuilder b = new StringBuilder();
        if (header.isWeak()) {
            b.append("W/");
        }
        WriterUtil.appendQuoted(b, header.getValue());
        return b.toString();
    }

    @Override
    public EntityTag fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Entity tag is null");
        }
        try {
            HttpHeaderReader reader = HttpHeaderReader.newInstance(header);
            HttpHeaderReader.Event e = reader.next(false);
            if (e == HttpHeaderReader.Event.QuotedString) {
                return new EntityTag(reader.getEventValue());
            }
            if (e == HttpHeaderReader.Event.Token && reader.getEventValue().equals("W")) {
                reader.nextSeparator('/');
                return new EntityTag(reader.nextQuotedString(), true);
            }
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing entity tag '" + header + "'", ex);
        }
        throw new IllegalArgumentException("Error parsing entity tag '" + header + "'");
    }
}

