/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.jersey.api.client;

import java.io.IOException;
import java.io.OutputStream;

public abstract class CommittingOutputStream
extends OutputStream {
    private OutputStream o;
    private boolean isCommitted;

    public CommittingOutputStream() {
    }

    public CommittingOutputStream(OutputStream o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.o = o;
    }

    public void write(byte[] b) throws IOException {
        this.commitWrite();
        this.o.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.commitWrite();
        this.o.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.commitWrite();
        this.o.write(b);
    }

    public void flush() throws IOException {
        this.commitWrite();
        this.o.flush();
    }

    public void close() throws IOException {
        this.commitWrite();
        this.o.close();
    }

    private void commitWrite() throws IOException {
        if (!this.isCommitted) {
            this.isCommitted = true;
            this.commit();
            if (this.o == null) {
                this.o = this.getOutputStream();
            }
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        throw new IllegalStateException();
    }

    protected abstract void commit() throws IOException;
}

