/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl;

import com.inwebo.repackaged.apache.commons.logging.Log;
import com.inwebo.repackaged.apache.commons.logging.LogFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager == null ? (class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager = EasyX509TrustManager.class$("com.inwebo.repackaged.apache.commons.httpclient.contrib.ssl.EasyX509TrustManager")) : class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager);
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$EasyX509TrustManager;

    public EasyX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray != null && LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                LOG.debug("X509Certificate[" + i + "]=" + x509CertificateArray[i]);
            }
        }
        if (x509CertificateArray != null && x509CertificateArray.length == 1) {
            x509CertificateArray[0].checkValidity();
        } else {
            this.standardTrustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

