/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.jersey.api.client.filter;

import com.inwebo.repackaged.jersey.api.client.ClientHandlerException;
import com.inwebo.repackaged.jersey.api.client.ClientRequest;
import com.inwebo.repackaged.jersey.api.client.ClientResponse;
import com.inwebo.repackaged.jersey.api.client.filter.ClientFilter;
import com.inwebo.repackaged.jersey.core.util.Base64;
import java.io.UnsupportedEncodingException;

public final class HTTPBasicAuthFilter
extends ClientFilter {
    private final String authentication;

    public HTTPBasicAuthFilter(String username, String password) {
        try {
            this.authentication = "Basic " + new String(Base64.encode(username + ":" + password), "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (!cr.getMetadata().containsKey("Authorization")) {
            cr.getMetadata().add("Authorization", this.authentication);
        }
        return this.getNext().handle(cr);
    }
}

