/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.integrations.netiq;

import com.inwebo.integrations.auth.InWeboRestAuthenticator;
import com.inwebo.integrations.netiq.Property;
import com.novell.nidp.NIDPPrincipal;
import com.novell.nidp.NIDPSession;
import com.novell.nidp.NIDPSessionData;
import com.novell.nidp.authentication.local.LocalAuthenticationClass;
import com.novell.nidp.authentication.local.PageToShow;
import com.novell.nidp.authentication.local.STSAuthenticationClass;
import com.novell.nidp.common.authority.PasswordExpiredException;
import com.novell.nidp.common.authority.PasswordExpiringException;
import com.novell.nidp.common.authority.UserAuthority;
import com.novell.nidp.common.authority.ldap.LDAPPrincipal;
import com.novell.nidp.logging.NIDPLog;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.IUsernameToken;

public class InWeboAuthModule
extends LocalAuthenticationClass
implements STSAuthenticationClass {
    private static final String INWEBO_BROWSER_ALIAS_REQUEST_PARAM_NAME = "inWeboBrowserAlias";
    private final InWeboRestAuthenticator authenticator;
    private final String browserAlias;
    private String userErrorMsg;

    public InWeboAuthModule(Properties properties, ArrayList<UserAuthority> arrayList) throws Exception {
        super(properties, arrayList);
        this.authenticator = new InWeboRestAuthenticator(properties, NIDPLog.getAppLog());
        this.browserAlias = properties.getProperty(Property.BOOKMARK_ALIAS.key(), Property.BOOKMARK_ALIAS.defaultValue());
    }

    public String getType() {
        return "Password";
    }

    public void initializeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, NIDPSession nIDPSession, NIDPSessionData nIDPSessionData, boolean bl, String string) {
        super.initializeRequest(httpServletRequest, httpServletResponse, nIDPSession, nIDPSessionData, bl, string);
        httpServletRequest.setAttribute(INWEBO_BROWSER_ALIAS_REQUEST_PARAM_NAME, (Object)this.browserAlias);
    }

    protected int doAuthenticate() {
        String string;
        String string2;
        int n;
        if (!this.isFirstCallAfterPrevMethod() && (n = this.handlePostedData()) != 2) {
            return n;
        }
        String string3 = this.getProperty("JSP");
        if (string3 == null || string3.trim().length() == 0) {
            string3 = "inWeboLoginPage";
        }
        this.m_PageToShow = new PageToShow(string3);
        this.m_PageToShow.addAttribute(INWEBO_BROWSER_ALIAS_REQUEST_PARAM_NAME, this.browserAlias);
        this.m_PageToShow.addAttribute("url", this.getReturnURL() != null ? this.getReturnURL() : this.m_Request.getRequestURL().toString());
        if (this.getAuthnRequest() != null && this.getAuthnRequest().getTarget() != null) {
            this.m_PageToShow.addAttribute("target", this.getAuthnRequest().getTarget());
        }
        if ((string2 = this.m_Request.getParameter("Ecom_User_ID")) != null) {
            this.m_PageToShow.addAttribute("username", string2);
        }
        if ((string = this.m_Request.getParameter("option")) != null && string.equals("credential") && this.userErrorMsg != null) {
            this.m_PageToShow.addAttribute("loginError", this.userErrorMsg);
            this.userErrorMsg = null;
        }
        return 6;
    }

    private int handlePostedData() {
        String string = this.m_Request.getParameter("Ecom_User_ID");
        String string2 = this.m_Request.getParameter("Ecom_Password");
        this.setUserId(string);
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            Boolean bl = this.authenticator.authorize(string, string2);
            if (bl.booleanValue()) {
                return this.identifyPrincipal(string);
            }
            this.setFailure();
            this.setErrorMsg("NIDPMAIN.1528", string);
            return 2;
        }
        super.setErrorMsg("NIDPMAIN.125", "NIDPMAIN.1527");
        return 2;
    }

    protected void setErrorMsg(String string, String string2) {
        super.setErrorMsg("NIDPMAIN.125", string, string2);
        this.userErrorMsg = this.getUserErrorMsg();
    }

    private int identifyPrincipal(String string) {
        NIDPPrincipal nIDPPrincipal = this.findPrincipal(string);
        if (nIDPPrincipal != null) {
            this.setPrincipal(nIDPPrincipal);
            if (nIDPPrincipal instanceof LDAPPrincipal) {
                this.addLDAPCredentials();
            }
            return 0;
        }
        return 2;
    }

    private NIDPPrincipal findPrincipal(String string) {
        String string2 = this.checkForQuery();
        if (string2 != null) {
            NIDPPrincipal[] nIDPPrincipalArray;
            if (NIDPLog.isLoggableAppFine()) {
                NIDPLog.logAppInfo((String)("Attempted findPrincipalWithQuery - query = " + string2));
            }
            if ((nIDPPrincipalArray = this.findPrincipalsByQuery(string2)) != null && nIDPPrincipalArray.length > 0) {
                if (nIDPPrincipalArray.length == 1) {
                    return nIDPPrincipalArray[0];
                }
                this.setFailure();
                this.setErrorMsg("NIDPMAIN.1531", string2);
            } else {
                this.setFailure();
                this.setErrorMsg("NIDPMAIN.1530", string2);
            }
        } else {
            NIDPPrincipal[] nIDPPrincipalArray;
            if (NIDPLog.isLoggableAppFine()) {
                NIDPLog.logAppFine((String)("Attempted findPrincipal - id = " + string));
            }
            if ((nIDPPrincipalArray = this.findPrincipals(this.escapeName(string))) != null && nIDPPrincipalArray.length > 0) {
                if (nIDPPrincipalArray.length == 1) {
                    return nIDPPrincipalArray[0];
                }
                this.setFailure();
                this.setErrorMsg("NIDPMAIN.1529", string);
            } else {
                this.setFailure();
                this.setErrorMsg("NIDPMAIN.1528", string);
            }
        }
        return null;
    }

    public NIDPPrincipal handleSTSAuthentication(ISecurityInformation iSecurityInformation) {
        IUsernameToken iUsernameToken = (IUsernameToken)iSecurityInformation.getFirst(IUsernameToken.class);
        if (null != iUsernameToken) {
            try {
                if (this.authenticateWithPassword(iUsernameToken.getUsername(), iUsernameToken.getPassword())) {
                    return this.getPrincipal();
                }
            }
            catch (PasswordExpiringException passwordExpiringException) {
                return this.getPrincipal();
            }
            catch (PasswordExpiredException passwordExpiredException) {
                // empty catch block
            }
        }
        return null;
    }
}

