/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.jvnet.tiger_types;

import com.inwebo.repackaged.org.jvnet.tiger_types.GenericArrayTypeImpl;
import com.inwebo.repackaged.org.jvnet.tiger_types.ParameterizedTypeImpl;
import com.inwebo.repackaged.org.jvnet.tiger_types.TypeVisitor;
import com.inwebo.repackaged.org.jvnet.tiger_types.WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Types {
    private static final TypeVisitor<Type, Class> baseClassFinder = new TypeVisitor<Type, Class>(){

        @Override
        public Type onClass(Class c, Class sup) {
            Type r;
            if (sup == c) {
                return sup;
            }
            Type sc = c.getGenericSuperclass();
            if (sc != null && (r = (Type)this.visit(sc, sup)) != null) {
                return r;
            }
            for (Type i : c.getGenericInterfaces()) {
                r = (Type)this.visit(i, sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, Class sup) {
            Class raw = (Class)p.getRawType();
            if (raw == sup) {
                return p;
            }
            Type r = raw.getGenericSuperclass();
            if (r != null) {
                r = (Type)this.visit(this.bind(r, raw, p), sup);
            }
            if (r != null) {
                return r;
            }
            for (Type i : raw.getGenericInterfaces()) {
                r = (Type)this.visit(this.bind(i, raw, p), sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onGenericArray(GenericArrayType g, Class sup) {
            return null;
        }

        @Override
        public Type onVariable(TypeVariable v, Class sup) {
            return (Type)this.visit(v.getBounds()[0], sup);
        }

        @Override
        public Type onWildcard(WildcardType w, Class sup) {
            return null;
        }

        private Type bind(Type t, GenericDeclaration decl, ParameterizedType args) {
            return (Type)binder.visit(t, new BinderArg(decl, args.getActualTypeArguments()));
        }
    };
    private static final TypeVisitor<Type, BinderArg> binder = new TypeVisitor<Type, BinderArg>(){

        @Override
        public Type onClass(Class c, BinderArg args) {
            return c;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, BinderArg args) {
            Type[] params = p.getActualTypeArguments();
            boolean different = false;
            for (int i = 0; i < params.length; ++i) {
                Type t = params[i];
                params[i] = (Type)this.visit(t, args);
                different |= t != params[i];
            }
            Type newOwner = p.getOwnerType();
            if (newOwner != null) {
                newOwner = (Type)this.visit(newOwner, args);
            }
            if (!(different |= p.getOwnerType() != newOwner)) {
                return p;
            }
            return new ParameterizedTypeImpl((Class)p.getRawType(), params, newOwner);
        }

        @Override
        public Type onGenericArray(GenericArrayType g, BinderArg types) {
            Type c = (Type)this.visit(g.getGenericComponentType(), types);
            if (c == g.getGenericComponentType()) {
                return g;
            }
            return new GenericArrayTypeImpl(c);
        }

        @Override
        public Type onVariable(TypeVariable v, BinderArg types) {
            return types.replace(v);
        }

        @Override
        public Type onWildcard(WildcardType w, BinderArg types) {
            Type t;
            int i;
            Type[] lb = w.getLowerBounds();
            Type[] ub = w.getUpperBounds();
            boolean diff = false;
            for (i = 0; i < lb.length; ++i) {
                t = lb[i];
                lb[i] = (Type)this.visit(t, types);
                diff |= t != lb[i];
            }
            for (i = 0; i < ub.length; ++i) {
                t = ub[i];
                ub[i] = (Type)this.visit(t, types);
                diff |= t != ub[i];
            }
            if (!diff) {
                return w;
            }
            return new WildcardTypeImpl(lb, ub);
        }
    };
    private static final TypeVisitor<Class, Void> eraser = new TypeVisitor<Class, Void>(){

        @Override
        public Class onClass(Class c, Void _) {
            return c;
        }

        @Override
        public Class onParameterizdType(ParameterizedType p, Void _) {
            return (Class)this.visit(p.getRawType(), null);
        }

        @Override
        public Class onGenericArray(GenericArrayType g, Void _) {
            return Array.newInstance((Class)this.visit(g.getGenericComponentType(), null), 0).getClass();
        }

        @Override
        public Class onVariable(TypeVariable v, Void _) {
            return (Class)this.visit(v.getBounds()[0], null);
        }

        @Override
        public Class onWildcard(WildcardType w, Void _) {
            return (Class)this.visit(w.getUpperBounds()[0], null);
        }
    };

    public static Type getBaseClass(Type type, Class baseType) {
        return baseClassFinder.visit(type, baseType);
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                return Types.getTypeName(c.getComponentType()) + "[]";
            }
            return c.getName();
        }
        return type.toString();
    }

    public static boolean isSubClassOf(Type sub, Type sup) {
        return Types.erasure(sup).isAssignableFrom(Types.erasure(sub));
    }

    public static <T> Class<T> erasure(Type t) {
        return eraser.visit(t, null);
    }

    public static ParameterizedType createParameterizedType(Class rawType, Type ... arguments) {
        return new ParameterizedTypeImpl(rawType, arguments, null);
    }

    public static boolean isArray(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c.isArray();
        }
        return t instanceof GenericArrayType;
    }

    public static boolean isArrayButNotByteArray(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c.isArray() && c != byte[].class;
        }
        if (t instanceof GenericArrayType) {
            return (t = ((GenericArrayType)t).getGenericComponentType()) != Byte.TYPE;
        }
        return false;
    }

    public static Type getComponentType(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c.getComponentType();
        }
        if (t instanceof GenericArrayType) {
            return ((GenericArrayType)t).getGenericComponentType();
        }
        throw new IllegalArgumentException();
    }

    public static Type getTypeArgument(Type type, int i) {
        Type r = Types.getTypeArgument(type, i, null);
        if (r == null) {
            throw new IllegalArgumentException();
        }
        return r;
    }

    public static Type getTypeArgument(Type type, int i, Type defaultValue) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return Types.fix(p.getActualTypeArguments()[i]);
        }
        return defaultValue;
    }

    public static boolean isPrimitive(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isPrimitive();
        }
        return false;
    }

    public static boolean isOverriding(Method method, Class base) {
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        while (base != null) {
            try {
                if (base.getDeclaredMethod(name, params) != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            base = base.getSuperclass();
        }
        return false;
    }

    private static Type fix(Type t) {
        if (!(t instanceof GenericArrayType)) {
            return t;
        }
        GenericArrayType gat = (GenericArrayType)t;
        if (gat.getGenericComponentType() instanceof Class) {
            Class c = (Class)gat.getGenericComponentType();
            return Array.newInstance(c, 0).getClass();
        }
        return t;
    }

    private static class BinderArg {
        final TypeVariable[] params;
        final Type[] args;

        BinderArg(TypeVariable[] params, Type[] args) {
            this.params = params;
            this.args = args;
            assert (params.length == args.length);
        }

        public BinderArg(GenericDeclaration decl, Type[] args) {
            this(decl.getTypeParameters(), args);
        }

        Type replace(TypeVariable v) {
            for (int i = 0; i < this.params.length; ++i) {
                if (!this.params[i].equals(v)) continue;
                return this.args[i];
            }
            return v;
        }
    }
}

