/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.com.google.common.collect;

import com.inwebo.repackaged.com.google.common.collect.CollectPreconditions;
import com.inwebo.repackaged.com.google.common.collect.ImmutableEntry;
import com.inwebo.repackaged.javax.annotation.Nullable;

abstract class ImmutableMapEntry<K, V>
extends ImmutableEntry<K, V> {
    ImmutableMapEntry(K key, V value) {
        super(key, value);
        CollectPreconditions.checkEntryNotNull(key, value);
    }

    ImmutableMapEntry(ImmutableMapEntry<K, V> contents) {
        super(contents.getKey(), contents.getValue());
    }

    @Nullable
    abstract ImmutableMapEntry<K, V> getNextInKeyBucket();

    static final class TerminalEntry<K, V>
    extends ImmutableMapEntry<K, V> {
        TerminalEntry(K key, V value) {
            super(key, value);
        }

        @Override
        @Nullable
        ImmutableMapEntry<K, V> getNextInKeyBucket() {
            return null;
        }
    }
}

