/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.integrations.auth;

import com.inwebo.integrations.auth.Property;
import com.inwebo.repackaged.javax.ws.rs.client.Client;
import com.inwebo.repackaged.javax.ws.rs.core.Response;
import com.inwebo.repackaged.org.apache.http.config.Registry;
import com.inwebo.repackaged.org.apache.http.config.RegistryBuilder;
import com.inwebo.repackaged.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.inwebo.repackaged.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.inwebo.repackaged.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.inwebo.repackaged.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.inwebo.repackaged.org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientConfig;
import com.inwebo.repackaged.org.glassfish.jersey.client.JerseyClientBuilder;
import com.inwebo.repackaged.org.glassfish.jersey.logging.LoggingFeature;
import com.inwebo.repackaged.org.json.simple.JSONObject;
import com.inwebo.repackaged.org.json.simple.parser.JSONParser;
import com.inwebo.repackaged.org.json.simple.parser.ParseException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class InWeboRestAuthenticator {
    public static final String DEFAULT_LOGGER_NAME = InWeboRestAuthenticator.class.getName();
    private static final String INWEBO_DEFAULT_BASE_URL = "https://api.myinwebo.com/FS";
    private final Logger filterLogger;
    public static final String RESULT_CODE_OK = "OK";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private final String baseUrl;
    private final ClientConfig config;
    private final Long serviceId;

    public InWeboRestAuthenticator(Properties properties) throws Exception {
        this(properties, null);
    }

    public InWeboRestAuthenticator(Properties properties, Logger logger) throws Exception {
        Objects.requireNonNull(properties);
        this.baseUrl = properties.getProperty(Property.BASE_URL.key(), INWEBO_DEFAULT_BASE_URL);
        this.serviceId = Long.valueOf(Objects.requireNonNull(properties.getProperty(Property.SERVICE_ID.key(), "'serviceId' cannot be null")));
        this.filterLogger = logger != null ? logger : Logger.getLogger(DEFAULT_LOGGER_NAME);
        this.config = new ClientConfig().register(new LoggingFeature(this.filterLogger)).property("jersey.config.apache.client.connectionManager", this.connectionManager(Objects.requireNonNull(properties.getProperty(Property.CERTIFICATE_PATH.key()), "'p12file' cannot be null"), Objects.requireNonNull(properties.getProperty(Property.CERTIFICATE_PASSWORD.key()), "'p12password' cannot be null"))).property("jersey.config.apache.client.connectionManagerShared", true).property("jersey.config.client.readTimeout", (int)TimeUnit.SECONDS.toMillis(30L)).property("jersey.config.client.connectTimeout", (int)TimeUnit.SECONDS.toMillis(30L)).connectorProvider(new ApacheConnectorProvider());
        this.initProxy(properties);
    }

    private void initProxy(Properties properties) {
        String proxyHost = properties.getProperty(Property.PROXY_HOST.key());
        String proxyPort = properties.getProperty(Property.PROXY_PORT.key());
        String proxyUser = properties.getProperty(Property.PROXY_USER.key());
        String proxyPassword = properties.getProperty(Property.PROXY_PASSWORD.key());
        boolean https = Boolean.valueOf(properties.getProperty(Property.PROXY_HTTPS.key(), "false"));
        if (proxyHost != null && proxyPort != null) {
            StringBuilder uri = new StringBuilder();
            if (https) {
                uri.append(HTTPS);
            } else {
                uri.append(HTTP);
            }
            uri.append("://").append(proxyHost).append(":").append(proxyPort);
            this.config.property("jersey.config.client.proxy.uri", uri.toString());
            if (proxyUser != null && proxyPassword != null) {
                this.config.property("jersey.config.client.proxy.username", proxyUser).property("jersey.config.client.proxy.password", proxyPassword);
            }
        } else {
            this.filterLogger.info("no proxy configured");
        }
    }

    private PoolingHttpClientConnectionManager connectionManager(String p12file, String p12password) throws Exception {
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register(HTTP, PlainConnectionSocketFactory.getSocketFactory()).register(HTTPS, (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(this.getContext(p12file, p12password)))).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        return connectionManager;
    }

    private InputStream getCertificateFile(String certificateFile) throws Exception {
        if (Files.exists(Paths.get(certificateFile, new String[0]), new LinkOption[0])) {
            return Files.newInputStream(Paths.get(certificateFile, new String[0]), new OpenOption[0]);
        }
        InputStream inputStream = InWeboRestAuthenticator.class.getResourceAsStream(certificateFile);
        if (inputStream == null) {
            inputStream = InWeboRestAuthenticator.class.getClassLoader().getResourceAsStream(certificateFile);
        }
        return inputStream;
    }

    private SSLContext getContext(String certificateFile, String certPassword) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (InputStream keyInput = this.getCertificateFile(certificateFile);){
            keyStore.load(keyInput, certPassword.toCharArray());
            keyManagerFactory.init(keyStore, certPassword.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            SSLContext sSLContext = context;
            return sSLContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject authenticate(String login, String token) {
        Client client = null;
        try {
            client = JerseyClientBuilder.newClient(this.config);
            Response response = client.target(this.baseUrl).queryParam("action", "authenticateExtended").queryParam("serviceId", this.serviceId).queryParam("userId", login).queryParam("token", token).queryParam("format", "json").request("application/json").get(Response.class);
            JSONObject jSONObject = this.getJsonObject(response);
            return jSONObject;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Boolean authorize(String login, String token) {
        JSONObject result = this.authenticate(login, token);
        if (result != null && RESULT_CODE_OK.equals(result.get("err"))) {
            this.filterLogger.info(String.format("Login by '%s' with '%s' - succeeded", login, token));
            return Boolean.TRUE;
        }
        this.filterLogger.info(String.format("Login by '%s' with '%s' - failed with result '%s'", login, token, result));
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getJsonObject(Response response) {
        if (response != null && response.getStatusInfo() != null && response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            try {
                var2_2 = (JSONObject)JSONObject.class.cast(new JSONParser().parse(response.readEntity(String.class)));
                return var2_2;
            }
            catch (ParseException var2_3) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_4 = null;
                    return var2_4;
                }
            }
        }
        status = response.getStatusInfo() == null ? "UNKNOWN" : String.valueOf(response.getStatusInfo().getStatusCode());
        this.filterLogger.severe("InWebo API Error with response status code: " + status);
        ** while (true)
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception var3_5) {}
            }
        }
    }
}

