<%@page import="com.novell.nidp.wsfed.protocol.WSFedAuthnRequest"%>
<%@page import="com.novell.nidp.common.protocol.AuthnRequest"%>
<%@ page language="java" %>
<%@ page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>
<%@ page import="java.util.*" %>
<%@ page import="com.novell.nidp.*" %>
<%@ page import="com.novell.nidp.common.util.*" %>
<%@ page import="com.novell.nidp.servlets.*" %>
<%@ page import="com.novell.nidp.resource.*" %>
<%@ page import="com.novell.nidp.resource.jsp.*" %>
<%@ page import="com.novell.nidp.ui.*" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="internal.atlaslite.jcce.util.StringUtil" %>
<%
    ContentHandler handler = new ContentHandler(request,response);
    int iMethodCounter = handler.getMethodCounter();
    String target = (String) request.getAttribute("target");
    String uname = (String)request.getAttribute("username");

    String strUserNamePwdValues = handler.getResource(JSPResDesc.ENTER_USERNAME_PWD_VALUES);
    String strValidatingCredentials = handler.getResource(JSPResDesc.VALIDATING_CREDENTIALS);
    String strSignIn = handler.getResource(JSPResDesc.SIGN_IN);
    String strNotOnPublicConputer = handler.getResource(JSPResDesc.NOT_ON_PUBLIC_COMPUTER);
    String strCommunicationsError = handler.getResource(JSPResDesc.ERROR_COMMS_TO_IDP);

    NIDPSessionData sData = NIDPContext.getNIDPContext().getSession(request).getSessionData(request.getParameter("sid"));
    AuthnRequest proxyReq = sData.getProxiedRequest();
    if(proxyReq instanceof WSFedAuthnRequest) {
        uname = ((WSFedAuthnRequest)proxyReq).getParameter("username");
    }

    if (uname == null) {
        uname = "";
    }

    uname = StringEscapeUtils.escapeHtml(uname);
    if (target != null) {
        target = StringEscapeUtils.escapeHtml(target);
    }

    String strGlobalMessageText = "";
    // If we are executing a POST authentication auth-method, then
    // we will not have the end user environment.
    boolean bProofOfEndUserEnvironment = true;
    String strCardId = (String) request.getParameter(ContentHandler.CARD_PARM);
    if (!StringUtil.isDefined(strCardId)) {
        strCardId = (String) request.getAttribute(ContentHandler.CARD_PARM);
    }
    if (StringUtil.isDefined(strCardId) && (strCardId.equals(NIDPConstants.POST_AUTH_CONTRACT_ID))) {
        bProofOfEndUserEnvironment = false;
    }
    String err = (String) request.getAttribute(NIDPConstants.ATTR_LOGIN_ERROR);
    String inWeboBrowserAlias = (String) request.getAttribute("inWeboBrowserAlias");
    if (!bProofOfEndUserEnvironment) {
%>
<!DOCTYPE html>
<html lang="<%=handler.getLanguageCode()%>">
<head>
    <title>inWebo Authenticator</title>
    <meta name="robots" content="noindex, nofollow" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
    <meta http-equiv="x-ua-compatible" content="IE=edge" />
    <script type="text/javascript" src="<%=request.getContextPath()%>/javascript/jquery-1.11.2.min.js"></script>
    <link rel="stylesheet" type="text/css"  href="<%=request.getContextPath()%>/css/inwebo.css"/>
    <script type="text/javascript" src="https://ult-inwebo.com/webapp/js/helium.min.js"></script>
    <script type="text/javascript" src="https://ult-inwebo.com/va/client.js"></script>
    <script type="text/javascript" src="<%=request.getContextPath()%>/javascript/inWeboBrowser-1.0.2-min.js"></script>
    <script type="text/javascript">
        function isEnterKey(event) {
            return isKey(event, 13);
        }
        function isSpaceKey(event) {
            return isKey(event, 32);
        }
        function isKey(event, targetKeyCode) {
            var candidateKeyCode = (event.which) ? event.which : event.keyCode;
            if (candidateKeyCode != targetKeyCode) {
                return false;
            }
            return true;
        }
    </script>
</head>
<body>
<% } else { %>
    <script type="text/javascript" src="<%=request.getContextPath()%>/javascript/inWeboBrowser-1.0.2-min.js"></script>
<% } %>

<div class="wrapper">
    <div class="container">
        <header>
            <a class="logo" href="https://www.inwebo.com/" target="_blank"><img src="<%=request.getContextPath()%>/images/inWeboLogo.png"/></a>
        </header>
        <div class="content">

            <!-- Parameter divs  -->
            <div id="vaStart" data-action="authentication" data-container="vaContainer" data-lang="auto" data-quiet-start="1" data-alias="<%=inWeboBrowserAlias%>" data-width="auto" style="display:none;"></div>
            <div id="heliumAuthenticate" alias="<%=inWeboBrowserAlias%>" action="authenticate" lang="auto" style="display:none"></div>
            <div id="heliumDesign" withlogo="0" rounded="1" shaded="0" displaytype="inline" container="helium_form" skin="default" maincolor="#28AA28" withtitle="0" withborder="1" style="display:none"></div>
            <div id="inWeboMsgNoLogin" style="display:none;">We didn't recognize the username or OTP you entered. Please try again.</div>
            <div id="inWeboMsgNoMA" style="display:none;">There is no registered mobile phone for this login. Please try again.</div>
            <div id="inWeboMsgNoSupported" style="display:none;">We were not able to send a push notification on your mobile. Please try again.</div>
            <div id="inWeboMsgUserRefused" style="display:none;">The logon process has been explicitly refused on the mobile. Please try again.</div>
            <div id="inWeboMsgTimeOut" style="display:none;">Authentication timeout. Please retry again.</div>
            <div id="inwebo_login" name="inwebo_login" style="display:none;"></div>
            <div id="inwebologin" name="inwebologin" style="display:none;"></div>
            <!-- End Parameter divs  -->

            <div id="inWeboError">
                <div id="errorGlobalMessage" class="form-element-wrapper">
                    <% if (err != null) { %>
                        <p class="form-element form-error"><%=HTMLUtil.stringToJavaScriptString(err)%></p>
                    <% } %>
                </div>
            </div>

            <div id="loading-div-background">
                <div id="loading-div" class="ui-corner-all" >
                    <img style="height:80px;margin:30px;" src="<%=request.getContextPath()%>/images/inWeboLoading.gif" alt="Loading..."/>
                    <h2 style="color:gray;font-weight:bold;">Connecting...</h2>
                </div>
            </div>

            <div id="inWeboBrowser">
                <div id="vaContainer" style="display:none;"></div>
                <div style="width:465px;">
                    <div id="helium_form" style="display:none;"></div>
                </div>
            </div>

            <div id="inWeboPush" style="display:none;">
                <h1>inWebo Push Notification</h1>
                <div style='display:none;'>
                    <div id='helium_push' style='display:none;'></div>
                </div>
                <div id="inWeboPushForm">
                    <div class="form-element-wrapper">
                        <label for="inWeboPushLogin"><%=handler.getResource(JSPResDesc.USERNAME_UNDER_LABEL)%></label>
                        <input id="inWeboPushLogin" class="form-element form-field" name="inWeboPushLogin" type="text" value="<%=uname%>">
                    </div>
                    <div class="form-element-wrapper">
                        <a class="iwButtonGreen heliumPushLink" title="Send Push by inWebo Authenticator">Send Push</a>
                    </div>
                </div>
            </div>

            <div id="loginForm" style="display:none;">
                <h1>inWebo Manual Authentication</h1>
                <form id="IDPLogin" name="IDPLogin" enctype="application/x-www-form-urlencoded" method="POST" action="<%= (String) request.getAttribute("url") %>" autocomplete="off">
                    <input type="hidden" name="option" value="credential">
<% if (target != null) { %>
                    <input type="hidden" name="target" value="<%=target%>">
<% } %>
                    <div class="form-element-wrapper">
                        <label for="Ecom_User_ID"><%=handler.getResource(JSPResDesc.USERNAME_UNDER_LABEL)%></label>
                        <input id="Ecom_User_ID" class="form-element form-field" name="Ecom_User_ID" type="text" value="<%=uname%>">
                    </div>
                    <div class="form-element-wrapper iw-password">
                        <label for="Ecom_Password">OTP</label>
                        <input id="Ecom_Password" class="form-element form-field" name="Ecom_Password" type="password" value="">
                    </div>
                    <div class="form-element-wrapper">
                        <a id="loginButton2" class="iwButtonGreen" title="Sign in"><%=strSignIn%></a>
                    </div>
                </form>
            </div>
            <div id="methodButtons">
                <div id="iwBrowserTokenLink">
                    <a onclick="startBrowserToken();" class="iwLinkGreen">Log in with my browser</a>
                </div>
                <div id="iwPushLink">
                    <a onclick="startPushDisplay();" class="iwLinkGreen">Log in with a mobile notification</a>
                </div>
                <div id="iwOtpLink">
                    <a onclick="startOtpDisplay();" class="iwLinkGreen">Log in with a one-time code (OTP)</a>
                </div>
            </div>
        </div>
    </div>
    <footer>
        <div class="container-footer">
            <p class="footer-text">© 2017 inWebo Technologies</p>
        </div>
    </footer>
</div>
<script type="text/javascript">
    function safeSetGlobalMessage(strMessage) {
        var proofOfEndUserEnvironment = document.getElementById("runningInEndUserLoginEnvironment");
        if (proofOfEndUserEnvironment) {
            setGlobalMessage(strMessage);
        }
    }
    function submitForm() {
        var userNameEditBox = document.getElementById("Ecom_User_ID");
        var passwordEditBox = document.getElementById("Ecom_Password");
        if ((null != userNameEditBox) && (null != passwordEditBox)) {
            if ((0 == userNameEditBox.value.length) || (0 == passwordEditBox.value.length)) {
                hideProgressAnimation();
                safeSetGlobalErrorMessage("<%=HTMLUtil.stringToJavaScriptString(strUserNamePwdValues)%>");
                userNameEditBox.focus();
                return;
            }

            // Get some values from elements on the page:
            var form = document.getElementById("IDPLogin");
            var url = form.action;

            safeSetGlobalMessage("<%=HTMLUtil.stringToJavaScriptString(strValidatingCredentials)%>");

            var proofOfEndUserEnvironment= document.getElementById('runningInEndUserLoginEnvironment');
            if (proofOfEndUserEnvironment) {
                // Send the data using post
                var posting = $.post(url, $("#IDPLogin").serialize());
                // Put the results in a div
                posting.done(function(data) {
                    postDone(data);
                });

                posting.fail(function() {;
                    postFail("<%=HTMLUtil.stringToJavaScriptString(strCommunicationsError)%>");
                });
            } else {
                document.IDPLogin.submit();
            }
        }
    }
    $("document").ready(function() {
        $("#loginButton2").click(function(e) {
            e.preventDefault();
            showProgressAnimation();
            submitForm();
        });
        $("#loginButton2").keyup(function(event) {
            if (isEnterKey(event) || isSpaceKey(event)) {
                $("#loginButton2").click();
            }
        });
        $("#Ecom_User_ID").keyup(function(event) {
            if (isEnterKey(event)) {
                if (document.IDPLogin.Ecom_User_ID.value) {
                    $("#loginButton2").click();
            	    return false;
            	}
            }
            return true;
        });
        $("#Ecom_Password").keyup(function(event) {
            if (isEnterKey(event)) {
                if (document.IDPLogin.Ecom_User_ID.value) {
            	    $("#loginButton2").click();
            	    return false;
            	}
            }
            return true;
        });
        startBrowserToken();
    });
</script>
<% if ((iMethodCounter > 0) || (handler.isAuthenticatedSession())) {
       strGlobalMessageText = handler.getResource(JSPResDesc.LOGIN_FOR_MULTI_FACTOR);
%>
<script type="text/javascript">
    safeSetGlobalMessage("<%=HTMLUtil.stringToJavaScriptString(strGlobalMessageText)%>");
</script>
<%  } %>
<% if (!bProofOfEndUserEnvironment) { %>
    </body>
    </html>
<% } %>